/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing;

import org.chocosolver.memory.IStateDoubleVector;
import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.memory.trailing.trail.StoredDoubleVectorTrail;

public final class StoredDoubleVector
extends IStateDoubleVector {
    public int[] worldStamps;
    private final StoredDoubleVectorTrail myTrail;

    public StoredDoubleVector(EnvironmentTrailing env, int initialSize, double initialValue) {
        super(env, initialSize, initialValue);
        int initialCapacity = Math.max(8, initialSize);
        int w = env.getWorldIndex();
        this.worldStamps = new int[initialCapacity];
        for (int i = 0; i < initialSize; ++i) {
            this.worldStamps[i] = w;
        }
        this.myTrail = env.getDoubleVectorTrail();
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            double[] oldData = this.elementData;
            int[] oldStamps = this.worldStamps;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new double[newCapacity];
            this.worldStamps = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size.get());
            System.arraycopy(oldStamps, 0, this.worldStamps, 0, this.size.get());
        }
    }

    public void add(double i) {
        int newsize = this.size.get() + 1;
        this.ensureCapacity(newsize);
        this.size.set(newsize);
        this.elementData[newsize - 1] = i;
        this.worldStamps[newsize - 1] = this.environment.getWorldIndex();
    }

    public void remove(int i) {
        System.arraycopy(this.elementData, i, this.elementData, i + 1, this.size.get());
        System.arraycopy(this.worldStamps, i, this.worldStamps, i + 1, this.size.get());
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    public void removeLast() {
        int newsize = this.size.get() - 1;
        if (newsize >= 0) {
            this.size.set(newsize);
        }
    }

    public double set(int index, double val) {
        if (this.rangeCheck(index)) {
            return this.quickSet(index, val);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size.get());
    }

    @Override
    public double quickSet(int index, double val) {
        assert (this.rangeCheck(index));
        double oldValue = this.elementData[index];
        if (val != oldValue) {
            int oldStamp = this.worldStamps[index];
            if (oldStamp < this.environment.getWorldIndex()) {
                this.myTrail.savePreviousState(this, index, oldValue, oldStamp);
                this.worldStamps[index] = this.environment.getWorldIndex();
            }
            this.elementData[index] = val;
        }
        return oldValue;
    }

    public double _set(int index, double val, int stamp) {
        assert (this.rangeCheck(index));
        double oldval = this.elementData[index];
        this.elementData[index] = val;
        this.worldStamps[index] = stamp;
        return oldval;
    }
}

