/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.shrinkage.BayesianBridgeShrinkageOperator;
import dr.math.distributions.GammaDistribution;

public class DimensionMismatchedBayesianBridgeShrinkageOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private final BayesianBridgeStatisticsProvider provider;
    private final BayesianBridgeShrinkageOperator operator;
    private final Parameter globalScale;
    private final Parameter localScale;
    private final Parameter regressionExponent;
    private final Parameter mask;
    private final int dim;
    private final int effectiveDim;
    private final GammaDistribution globalScalePrior;

    public DimensionMismatchedBayesianBridgeShrinkageOperator(BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider, GammaDistribution gammaDistribution, Parameter parameter, BayesianBridgeShrinkageOperator bayesianBridgeShrinkageOperator, double d) {
        this.setWeight(d);
        this.provider = bayesianBridgeStatisticsProvider;
        this.globalScale = bayesianBridgeStatisticsProvider.getGlobalScale();
        this.localScale = bayesianBridgeStatisticsProvider.getLocalScale();
        this.regressionExponent = bayesianBridgeStatisticsProvider.getExponent();
        this.mask = parameter;
        this.dim = bayesianBridgeStatisticsProvider.getDimension();
        this.effectiveDim = this.getEffectiveDim();
        this.operator = bayesianBridgeShrinkageOperator;
        this.globalScalePrior = gammaDistribution;
    }

    @Override
    public String getOperatorName() {
        return "dimensionMismatchedBayesianBridgeGibbsOperator";
    }

    @Override
    public double doOperation() {
        if (this.globalScalePrior != null) {
            this.sampleGlobalScale();
        }
        if (this.localScale != null) {
            this.sampleLocalScale();
        }
        return 0.0;
    }

    private boolean exists(int n) {
        return this.mask == null || this.mask.getParameterValue(n) == 1.0;
    }

    private int getEffectiveDim() {
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.exists(i)) continue;
            ++n;
        }
        return n;
    }

    private int[] getDimensionMap() {
        int[] nArray = new int[this.dim];
        int n = 0;
        for (int i = 0; i < this.dim; ++i) {
            nArray[i] = this.exists(i) ? n++ : -1;
        }
        return nArray;
    }

    private double absSumBeta() {
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            if (!this.exists(i)) continue;
            d2 += Math.pow(Math.abs(this.provider.getCoefficient(i)), d);
        }
        return d2;
    }

    public void sampleGlobalScale() {
        double d = this.operator.drawGlobalScale(this.globalScalePrior.getShape(), this.globalScalePrior.getScale(), this.regressionExponent.getParameterValue(0), this.effectiveDim, this.absSumBeta());
        this.globalScale.setParameterValue(0, d);
    }

    private void sampleLocalScale() {
        int[] nArray = this.getDimensionMap();
        double d = this.regressionExponent.getParameterValue(0);
        double d2 = this.globalScale.getParameterValue(0);
        for (int i = 0; i < this.dim; ++i) {
            if (!this.exists(i)) continue;
            double d3 = this.operator.drawSingleLocalScale(d2, d, this.provider.getCoefficient(i));
            this.localScale.setParameterValueQuietly(nArray[i], d3);
        }
        this.localScale.fireParameterChangedEvent();
    }
}

