/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.MicrosatelliteSamplerTreeModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.oldevomodel.substmodel.MicrosatelliteModel;

public class MicrosatelliteFullAncestryImportanceSamplingOperator
extends SimpleMCMCOperator {
    public static final String MSAT_FULL_ANCESTRY_IMPORTANCE_SAMPLING_OPERATOR = "MsatFullAncestryImportanceSamplingOperator";
    private Parameter parameter;
    private MicrosatelliteSamplerTreeModel msatSamplerTreeModel;
    private MicrosatelliteModel msatModel;
    private BranchRateModel branchRateModel;

    public MicrosatelliteFullAncestryImportanceSamplingOperator(Parameter parameter, MicrosatelliteSamplerTreeModel microsatelliteSamplerTreeModel, MicrosatelliteModel microsatelliteModel, BranchRateModel branchRateModel, double d) {
        this.parameter = parameter;
        this.msatSamplerTreeModel = microsatelliteSamplerTreeModel;
        this.msatModel = microsatelliteModel;
        this.branchRateModel = branchRateModel;
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        TreeModel treeModel = this.msatSamplerTreeModel.getTreeModel();
        int[] nArray = new int[treeModel.getNodeCount()];
        TreeUtils.postOrderTraversalList(treeModel, nArray);
        int n = treeModel.getExternalNodeCount();
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            if (nArray[i] < n) continue;
            NodeRef nodeRef = treeModel.getNode(nArray[i]);
            NodeRef nodeRef2 = treeModel.getChild(nodeRef, 0);
            NodeRef nodeRef3 = treeModel.getChild(nodeRef, 1);
            int n3 = this.msatSamplerTreeModel.getNodeValue(nodeRef2);
            int n4 = this.msatSamplerTreeModel.getNodeValue(nodeRef3);
            double d2 = treeModel.getBranchLength(nodeRef2) * this.branchRateModel.getBranchRate(treeModel, nodeRef2);
            double d3 = treeModel.getBranchLength(nodeRef3) * this.branchRateModel.getBranchRate(treeModel, nodeRef3);
            double[] dArray = this.msatModel.getColTransitionProbabilities(d2, n3);
            double[] dArray2 = this.msatModel.getColTransitionProbabilities(d3, n4);
            double[] dArray3 = new double[this.msatModel.getDataType().getStateCount()];
            int n5 = (int)this.parameter.getParameterValue(this.msatSamplerTreeModel.getParameterIndexFromNodeNumber(nArray[i]));
            if (i == nArray.length - 1) {
                double[] dArray4 = this.msatModel.getStationaryDistribution();
                for (int j = 0; j < dArray3.length; ++j) {
                    dArray3[j] = dArray[j] * dArray2[j] * dArray4[j];
                }
            } else {
                for (n2 = 0; n2 < dArray3.length; ++n2) {
                    dArray3[n2] = dArray[n2] * dArray2[n2];
                }
            }
            n2 = MathUtils.randomChoicePDF(dArray3);
            d = d + Math.log(dArray3[n5]) - Math.log(dArray3[n2]);
            this.parameter.setParameterValue(this.msatSamplerTreeModel.getParameterIndexFromNodeNumber(nArray[i]), n2);
        }
        return d;
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return MSAT_FULL_ANCESTRY_IMPORTANCE_SAMPLING_OPERATOR;
    }

    public int getStepCount() {
        return 1;
    }
}

