/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.app.beauti.util.CharSet;
import dr.app.beauti.util.CharSetBlock;
import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SimpleAlignment;
import dr.evolution.sequence.Sequence;

public class CharSetAlignment
extends SimpleAlignment {
    public CharSetAlignment(CharSet charSet, Alignment alignment) {
        this.setId(charSet.getName());
        for (int i = 0; i < alignment.getSequenceCount(); ++i) {
            Sequence sequence = alignment.getSequence(i);
            String string = alignment.getAlignedSequenceString(i);
            String string2 = this.filter(charSet, string);
            this.addSequence(new Sequence(sequence.getTaxon(), string2));
        }
        this.setDataType(alignment.getDataType());
    }

    private String filter(CharSet charSet, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSetBlock charSetBlock : charSet.getBlocks()) {
            int n = charSetBlock.getToSite();
            if (n <= 0) {
                n = string.length();
            }
            for (int i = charSetBlock.getFromSite(); i <= n; i += charSetBlock.getEvery()) {
                stringBuilder.append(string.charAt(i - 1));
            }
        }
        return stringBuilder.toString();
    }
}

