/*
 * Decompiled with CFR 0.152.
 */
package main;

import blbutil.Utilities;
import haplotype.SampleHapPairs;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import main.BasicAlleleProbs;
import main.CurrentData;
import main.GeneticMap;
import main.HapAlleleProbs;
import main.Par;
import sample.ImputationData;
import sample.LSHapBaum;

public final class LiAndStephensHapSampler {
    private final Par par;
    private final GeneticMap genMap;

    public LiAndStephensHapSampler(Par par, GeneticMap geneticMap) {
        if (par == null) {
            throw new IllegalArgumentException("par==null");
        }
        this.par = par;
        this.genMap = geneticMap;
    }

    public BasicAlleleProbs sample(CurrentData currentData, SampleHapPairs sampleHapPairs) {
        ConcurrentLinkedQueue<HapAlleleProbs> concurrentLinkedQueue = new ConcurrentLinkedQueue<HapAlleleProbs>();
        this.multiThreadedHapSample(currentData, sampleHapPairs, concurrentLinkedQueue, this.par.lowmem(), this.par.nthreads());
        HapAlleleProbs[] hapAlleleProbsArray = concurrentLinkedQueue.toArray(new HapAlleleProbs[0]);
        return new BasicAlleleProbs(hapAlleleProbsArray);
    }

    private void multiThreadedHapSample(CurrentData currentData, SampleHapPairs sampleHapPairs, Queue<HapAlleleProbs> queue, boolean bl, int n) {
        int n2 = sampleHapPairs.nSamples() + n;
        ArrayBlockingQueue<Integer> arrayBlockingQueue = new ArrayBlockingQueue<Integer>(n2);
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ImputationData imputationData = new ImputationData(this.par, currentData, sampleHapPairs, this.genMap);
        try {
            int n3;
            int n4 = sampleHapPairs.nSamples();
            for (n3 = 0; n3 < n4; ++n3) {
                arrayBlockingQueue.put(n3);
            }
            for (n3 = 0; n3 < n; ++n3) {
                arrayBlockingQueue.put(-1);
            }
            for (n3 = 0; n3 < n; ++n3) {
                LSHapBaum lSHapBaum = new LSHapBaum(imputationData, bl);
                executorService.submit(new LSHapSampler(lSHapBaum, arrayBlockingQueue, queue));
            }
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("RecombHapSampler: ERROR", throwable);
        }
    }

    private class LSHapSampler
    implements Runnable {
        public static final int POISON = -1;
        private final LSHapBaum baum;
        private final BlockingQueue<Integer> qIn;
        private final Queue<HapAlleleProbs> qOut;

        public LSHapSampler(LSHapBaum lSHapBaum, BlockingQueue<Integer> blockingQueue, Queue<HapAlleleProbs> queue) {
            if (lSHapBaum == null) {
                throw new NullPointerException("baum=null");
            }
            if (blockingQueue == null) {
                throw new IllegalArgumentException("qIn==null");
            }
            this.baum = lSHapBaum;
            this.qIn = blockingQueue;
            this.qOut = queue;
        }

        @Override
        public void run() {
            try {
                int n = this.qIn.take();
                while (n != -1) {
                    int n2 = 2 * n;
                    int n3 = 2 * n + 1;
                    this.qOut.add(this.baum.randomHapSample(n2));
                    this.qOut.add(this.baum.randomHapSample(n3));
                    n = this.qIn.take();
                }
            }
            catch (Throwable throwable) {
                Utilities.exit("RecombHapSampler.LSHapSampler: ERROR", throwable);
            }
        }
    }
}

