/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import java.util.Arrays;
import java.util.Comparator;
import main.AlleleProbs;
import main.HapAlleleProbs;
import vcf.Marker;
import vcf.Markers;

public class BasicAlleleProbs
implements AlleleProbs {
    private final Markers markers;
    private final Samples samples;
    private final HapAlleleProbs[] alleleProbs;

    public BasicAlleleProbs(HapAlleleProbs[] hapAlleleProbsArray) {
        if (hapAlleleProbsArray.length == 0) {
            throw new IllegalArgumentException("alProbs.length==0");
        }
        this.alleleProbs = (HapAlleleProbs[])hapAlleleProbsArray.clone();
        Arrays.sort(this.alleleProbs, BasicAlleleProbs.comparator());
        this.markers = this.alleleProbs[0].markers();
        this.samples = this.alleleProbs[0].samples();
        for (int i = 1; i < this.alleleProbs.length; ++i) {
            if (!this.markers.equals(this.alleleProbs[i].markers())) {
                throw new IllegalArgumentException("inconsistent markers");
            }
            if (this.samples.equals(this.alleleProbs[i].samples())) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static Comparator<HapAlleleProbs> comparator() {
        return (hapAlleleProbs, hapAlleleProbs2) -> {
            if (hapAlleleProbs.hapIndex() != hapAlleleProbs2.hapIndex()) {
                return hapAlleleProbs.hapIndex() < hapAlleleProbs2.hapIndex() ? -1 : 1;
            }
            return 0;
        };
    }

    @Override
    public float alProb1(int n, int n2, int n3) {
        assert (this.alleleProbs[2 * n2].hapIndex() / 2 == n2);
        return this.alleleProbs[2 * n2].allele(n, n3);
    }

    @Override
    public float alProb2(int n, int n2, int n3) {
        assert (this.alleleProbs[2 * n2 + 1].hapIndex() / 2 == n2);
        return this.alleleProbs[2 * n2 + 1].allele(n, n3);
    }

    @Override
    public float gtProb(int n, int n2, int n3, int n4) {
        return this.alProb1(n, n2, n3) * this.alProb2(n, n2, n4);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.alleleProbs[2 * n2].alleleWithMaxProb(n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.alleleProbs[2 * n2 + 1].alleleWithMaxProb(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }
}

