/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.multidimensionalscaling;

import dr.inference.multidimensionalscaling.MultiDimensionalScalingCore;
import dr.inference.multidimensionalscaling.MultiDimensionalScalingLayout;
import dr.math.distributions.NormalDistribution;

public class MultiDimensionalScalingCoreImpl
implements MultiDimensionalScalingCore {
    private int embeddingDimension;
    private boolean isLeftTruncated = false;
    private int locationCount;
    private int observationCount;
    private double precision;
    private double storedPrecision;
    private int updatedLocation = -1;
    private double[][] observations;
    private double[][] locations;
    private double[][] storedLocations;
    private boolean incrementsKnown = false;
    private boolean sumOfIncrementsKnown = false;
    private double[][] increments;
    private double[] storedIncrements;
    private double sumOfIncrements;
    private double storedSumOfIncrements;

    @Override
    public void initialize(int n, int n2, long l) {
        this.embeddingDimension = n;
        this.locationCount = n2;
        this.observationCount = n2 * (n2 - 1) / 2;
        this.observations = new double[n2][n2];
        this.increments = new double[n2][n2];
        this.storedIncrements = null;
        this.incrementsKnown = false;
        this.sumOfIncrementsKnown = false;
        this.isLeftTruncated = (l & 0x20L) != 0L;
        this.updatedLocation = -1;
        this.locations = new double[n2][n];
        this.storedLocations = new double[n2][n];
    }

    @Override
    public void initialize(int n, MultiDimensionalScalingLayout multiDimensionalScalingLayout, long l) {
        throw new RuntimeException("Not yet implemented.\nIf you are trying to use the MassiveMDS parallelization library, then you need to specify the system property 'mds.required.flags' to be some number greater than 0.\nFor example: 'java -Dmds.required.flags=1 <everything else you would normally put to run BEAST>'");
    }

    @Override
    public void setNonMissingObservationCount(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setPairwiseData(double[] dArray) {
        if (dArray.length != this.locationCount * this.locationCount) {
            throw new RuntimeException("Observation data is not the correct dimension");
        }
        int n = 0;
        for (int i = 0; i < this.locationCount; ++i) {
            System.arraycopy(dArray, n, this.observations[i], 0, this.locationCount);
            n += this.locationCount;
        }
    }

    @Override
    public double[] getPairwiseData() {
        double[] dArray = new double[this.locationCount * this.locationCount];
        int n = 0;
        for (int i = 0; i < this.locationCount; ++i) {
            System.arraycopy(this.observations[i], 0, dArray, n, this.locationCount);
            n += this.locationCount;
        }
        return dArray;
    }

    @Override
    public int getInternalDimension() {
        return this.embeddingDimension;
    }

    @Override
    public void setParameters(double[] dArray) {
        this.precision = dArray[0];
        if (this.isLeftTruncated) {
            this.incrementsKnown = false;
            this.sumOfIncrementsKnown = false;
        }
    }

    @Override
    public void updateLocation(int n, double[] dArray) {
        if (this.updatedLocation != -1 || n == -1) {
            this.incrementsKnown = false;
            this.storedIncrements = null;
        }
        if (n != -1) {
            this.updatedLocation = n;
            if (dArray.length != this.embeddingDimension) {
                throw new RuntimeException("Location is not the correct dimension");
            }
            System.arraycopy(dArray, 0, this.locations[n], 0, this.embeddingDimension);
        } else {
            if (dArray.length != this.embeddingDimension * this.locationCount) {
                throw new RuntimeException("Location is the not correct dimension");
            }
            int n2 = 0;
            for (int i = 0; i < this.locationCount; ++i) {
                System.arraycopy(dArray, n2, this.locations[i], 0, this.embeddingDimension);
                n2 += this.embeddingDimension;
            }
        }
        this.sumOfIncrementsKnown = false;
    }

    @Override
    public double calculateLogLikelihood() {
        if (!this.sumOfIncrementsKnown) {
            if (!this.incrementsKnown) {
                this.computeSumOfSquaredResiduals();
            } else {
                this.updateSumOfSquaredResiduals();
            }
            this.sumOfIncrementsKnown = true;
        }
        double d = 0.5 * (Math.log(this.precision) - Math.log(Math.PI * 2)) * (double)this.observationCount;
        d = this.isLeftTruncated ? (d -= this.sumOfIncrements) : (d -= 0.5 * this.precision * this.sumOfIncrements);
        return d;
    }

    @Override
    public void storeState() {
        this.storedSumOfIncrements = this.sumOfIncrements;
        this.storedIncrements = null;
        for (int i = 0; i < this.locationCount; ++i) {
            System.arraycopy(this.locations[i], 0, this.storedLocations[i], 0, this.embeddingDimension);
        }
        this.updatedLocation = -1;
        this.storedPrecision = this.precision;
    }

    @Override
    public void restoreState() {
        this.sumOfIncrements = this.storedSumOfIncrements;
        this.sumOfIncrementsKnown = true;
        if (this.storedIncrements != null) {
            System.arraycopy(this.storedIncrements, 0, this.increments[this.updatedLocation], 0, this.locationCount);
            this.incrementsKnown = true;
        } else {
            this.incrementsKnown = false;
        }
        double[][] dArray = this.storedLocations;
        this.storedLocations = this.locations;
        this.locations = dArray;
        this.precision = this.storedPrecision;
    }

    @Override
    public void acceptState() {
        if (this.storedIncrements != null) {
            for (int i = 0; i < this.locationCount; ++i) {
                this.increments[i][this.updatedLocation] = this.increments[this.updatedLocation][i];
            }
        }
    }

    @Override
    public void getGradient(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void getObservationGradient(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void makeDirty() {
        this.sumOfIncrementsKnown = false;
        this.incrementsKnown = false;
    }

    private void computeSumOfSquaredResiduals() {
        double d = Math.sqrt(this.precision);
        double d2 = 0.5 * this.precision;
        this.sumOfIncrements = 0.0;
        for (int i = 0; i < this.locationCount; ++i) {
            for (int j = 0; j < this.locationCount; ++j) {
                double d3 = this.calculateDistance(this.locations[i], this.locations[j]);
                double d4 = d3 - this.observations[i][j];
                double d5 = d4 * d4;
                if (this.isLeftTruncated) {
                    d5 = d2 * d5;
                    if (i != j) {
                        d5 += this.computeTruncation(d3, d);
                    }
                }
                this.increments[i][j] = d5;
                this.sumOfIncrements += d5;
            }
        }
        this.sumOfIncrements /= 2.0;
        this.incrementsKnown = true;
        this.sumOfIncrementsKnown = true;
    }

    private void updateSumOfSquaredResiduals() {
        double d = Math.sqrt(this.precision);
        double d2 = 0.5 * this.precision;
        double d3 = 0.0;
        int n = this.updatedLocation;
        this.storedIncrements = new double[this.locationCount];
        System.arraycopy(this.increments[n], 0, this.storedIncrements, 0, this.locationCount);
        for (int i = 0; i < this.locationCount; ++i) {
            double d4 = this.calculateDistance(this.locations[n], this.locations[i]);
            double d5 = d4 - this.observations[n][i];
            double d6 = d5 * d5;
            if (this.isLeftTruncated) {
                d6 = d2 * d6;
                if (n != i) {
                    d6 += this.computeTruncation(d4, d);
                }
            }
            d3 += d6 - this.increments[n][i];
            this.increments[n][i] = d6;
        }
        this.sumOfIncrements += d3;
    }

    private double calculateDistance(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < this.embeddingDimension; ++i) {
            double d2 = dArray[i] - dArray2[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    private double computeTruncation(double d, double d2) {
        return NormalDistribution.standardCDF(d * d2, true);
    }
}

