/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.CPSolver;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.search.IntBranchingTrace;
import choco.kernel.solver.search.integer.IntVarValPair;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public final class NogoodRecorder {
    protected static final Logger LOGGER = ChocoLogging.getSearchLogger();
    protected final CPSolver scheduler;
    private int nbPosLits;
    private final IntDomainVar[] positiveLiterals;
    private int nbNegLits;
    private final IntDomainVar[] negativeLiterals;
    private final List<NoGoodTail> tails = new LinkedList<NoGoodTail>();

    public NogoodRecorder(CPSolver scheduler) {
        this.scheduler = scheduler;
        this.positiveLiterals = new IntDomainVar[scheduler.getNbBooleanVars()];
        this.negativeLiterals = new IntDomainVar[scheduler.getNbBooleanVars()];
    }

    public void reset() {
        this.nbPosLits = 0;
        this.nbNegLits = 0;
        this.tails.clear();
    }

    protected IntDomainVar getBranchingVar(IntBranchingTrace trace) {
        if (trace.getBranchingObject() instanceof IntDomainVar) {
            return (IntDomainVar)trace.getBranchingObject();
        }
        if (trace.getBranchingObject() instanceof IntVarValPair) {
            return ((IntVarValPair)trace.getBranchingObject()).var;
        }
        return null;
    }

    public void handleTrace(IntBranchingTrace trace) {
        IntDomainVar bvar = this.getBranchingVar(trace);
        if (bvar == null) {
            LOGGER.finest("reset nogood recording: not a integer variable");
            this.reset();
        } else if (!bvar.getDomain().isBoolean()) {
            LOGGER.finest("reset nogood recording: not a boolean variable");
            this.reset();
        } else if (trace.getBranchIndex() == 0) {
            if (!this.tails.isEmpty()) {
                if (bvar.getVal() == 0) {
                    this.positiveLiterals[this.nbPosLits++] = bvar;
                } else {
                    this.negativeLiterals[this.nbNegLits++] = bvar;
                }
            }
        } else {
            this.tails.add(new NoGoodTail(bvar, this.nbPosLits, this.nbNegLits));
        }
    }

    public void generateNogoods() {
        for (NoGoodTail tail : this.tails) {
            IntDomainVar[] negLits;
            IntDomainVar[] posLits;
            int sp = this.nbPosLits - tail.posLitsOffset;
            int sn = this.nbNegLits - tail.negLitsOffset;
            if (tail.tail.getVal() == 0) {
                posLits = new IntDomainVar[sp];
                negLits = new IntDomainVar[sn + 1];
                negLits[sn] = tail.tail;
            } else {
                posLits = new IntDomainVar[sp + 1];
                negLits = new IntDomainVar[sn];
                posLits[sp] = tail.tail;
            }
            System.arraycopy(this.positiveLiterals, tail.posLitsOffset, posLits, 0, sp);
            System.arraycopy(this.negativeLiterals, tail.negLitsOffset, negLits, 0, sn);
            this.scheduler.addNogood(posLits, negLits);
        }
    }

    private static final class NoGoodTail {
        public final IntDomainVar tail;
        public final int posLitsOffset;
        public final int negLitsOffset;

        public NoGoodTail(IntDomainVar tail, int nbPosLits, int nbNegLits) {
            this.tail = tail;
            this.posLitsOffset = nbPosLits;
            this.negLitsOffset = nbNegLits;
        }

        public String toString() {
            return this.tail + "(" + this.posLitsOffset + ", " + this.negLitsOffset + ")";
        }
    }
}

