/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified;

import choco.cp.solver.constraints.integer.channeling.ReifiedBinXor;
import choco.cp.solver.constraints.reified.ExpressionSConstraint;
import choco.cp.solver.constraints.reified.ReifiedAllSConstraint;
import choco.cp.solver.constraints.reified.ReifiedIntSConstraint;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class ReifiedFactory {
    private ReifiedFactory() {
    }

    public static SConstraint builder(IntDomainVar bool, SConstraint cons, Solver s) {
        return ReifiedFactory.builder(bool, cons, cons.opposite(s), s);
    }

    public static SConstraint builder(IntDomainVar bool, SConstraint cons, SConstraint oppcons, Solver solver) {
        SConstraintType c_int = cons.getConstraintType();
        SConstraintType oc_int = oppcons.getConstraintType();
        SConstraintType globalType = ReifiedFactory.merge(c_int, oc_int);
        switch (globalType) {
            case INTEGER: {
                return new ReifiedIntSConstraint(bool, (AbstractIntSConstraint)cons, (AbstractIntSConstraint)oppcons);
            }
            case EXPRESSION: {
                ExpressionSConstraint ec = (ExpressionSConstraint)cons;
                ExpressionSConstraint oec = (ExpressionSConstraint)cons;
                IntDomainVar vec = ec.expr.extractResult(solver);
                IntDomainVar voec = oec.expr.extractResult(solver);
                return new ReifiedBinXor(bool, vec, voec);
            }
        }
        return new ReifiedAllSConstraint(bool, (AbstractSConstraint)cons, (AbstractSConstraint)oppcons);
    }

    private static SConstraintType merge(SConstraintType c_int, SConstraintType oc_int) {
        if (c_int.equals((Object)oc_int)) {
            return c_int;
        }
        if (SConstraintType.EXPRESSION.equals((Object)c_int) || SConstraintType.EXPRESSION.equals((Object)oc_int)) {
            return SConstraintType.EXPRESSION;
        }
        return SConstraintType.MIXED;
    }
}

