/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.symmbreaking;

import java.util.HashSet;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIncrementalAdjacencyUndirectedMatrix
extends Propagator<Variable> {
    private final UndirectedGraphVar graph;
    private final IGraphDeltaMonitor gdm;
    private final PairProcedure enforce;
    private final PairProcedure remove;
    private int n;
    private final BoolVar[] t;

    public PropIncrementalAdjacencyUndirectedMatrix(UndirectedGraphVar graphVar, BoolVar[] t) {
        super(ArrayUtils.append({graphVar}, t), (Priority)PropagatorPriority.LINEAR, true);
        this.graph = graphVar;
        this.gdm = this.graph.monitorDelta(this);
        this.enforce = (from, to) -> {
            t[from + to * this.n].instantiateTo(1, (ICause)this);
            t[to + from * this.n].instantiateTo(1, (ICause)this);
        };
        this.remove = (from, to) -> {
            t[from + to * this.n].instantiateTo(0, (ICause)this);
            t[to + from * this.n].instantiateTo(0, (ICause)this);
        };
        this.n = graphVar.getNbMaxNodes();
        this.t = t;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.t[i + i * this.n].instantiateTo(0, (ICause)this);
        }
        this.propagateGraphChanged();
        this.propagateTChanged();
        this.gdm.startMonitoring();
    }

    private void propagateGraphChanged() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (this.t[i + j * this.n].isInstantiatedTo(1)) {
                    this.graph.enforceEdge(i, j, this);
                }
                if (!this.t[i + j * this.n].isInstantiatedTo(0)) continue;
                this.graph.removeEdge(i, j, this);
            }
        }
    }

    private void propagateTChanged() throws ContradictionException {
        int v2;
        int u;
        for (u = 0; u < this.n; ++u) {
            ISetIterator iSetIterator = this.graph.getMandatoryNeighborsOf(u).iterator();
            while (iSetIterator.hasNext()) {
                v2 = (Integer)iSetIterator.next();
                this.t[u + v2 * this.n].instantiateTo(1, (ICause)this);
            }
        }
        for (u = 0; u < this.n; ++u) {
            HashSet<Integer> set = new HashSet<Integer>();
            ISetIterator v2 = this.graph.getPotentialNeighborsOf(u).iterator();
            while (v2.hasNext()) {
                int v3 = (Integer)v2.next();
                set.add(v3);
            }
            for (v2 = 0; v2 < this.n; ++v2) {
                if (set.contains(v2)) continue;
                this.t[u + v2 * this.n].instantiateTo(0, (ICause)this);
            }
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp == 0) {
            this.gdm.forEachEdge(this.enforce, GraphEventType.ADD_EDGE);
            this.gdm.forEachEdge(this.remove, GraphEventType.REMOVE_EDGE);
        } else {
            this.propagateTChanged();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.ADD_EDGE.getMask() | GraphEventType.REMOVE_EDGE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int j;
        ISet children;
        int i;
        for (i = 0; i < this.n; ++i) {
            children = this.graph.getMandatoryNeighborsOf(i);
            for (j = 0; j < this.n; ++j) {
                if (!this.t[i + j * this.n].isInstantiatedTo(0) && !this.t[j + i * this.n].isInstantiatedTo(0) || !children.contains(j)) continue;
                return ESat.FALSE;
            }
        }
        for (i = 0; i < this.n; ++i) {
            children = this.graph.getPotentialNeighborsOf(i);
            for (j = 0; j < this.n; ++j) {
                if (!this.t[i + j * this.n].isInstantiatedTo(1) && !this.t[j + i * this.n].isInstantiatedTo(1) || children.contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.graph.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

