/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.channeling.edges;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class PropEdgeBoolChannel
extends Propagator<Variable> {
    private final BoolVar bool;
    private final int from;
    private final int to;
    private final GraphVar g;

    public PropEdgeBoolChannel(BoolVar isIn, int from, int to, GraphVar gV) {
        super(new Variable[]{isIn, gV}, (Priority)PropagatorPriority.UNARY, false);
        this.bool = isIn;
        this.from = from;
        this.to = to;
        this.g = gV;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 1) {
            return GraphEventType.ADD_EDGE.getMask() + GraphEventType.REMOVE_EDGE.getMask();
        }
        return IntEventType.all();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.from < 0 || this.to < 0 || this.from >= this.g.getNbMaxNodes() || this.to >= this.g.getNbMaxNodes() || !this.g.getPotentialSuccessorsOf(this.from).contains(this.to)) {
            this.bool.setToFalse(this);
        } else if (this.g.getMandatorySuccessorsOf(this.from).contains(this.to)) {
            this.bool.setToTrue(this);
        } else if (this.bool.getLB() == 1) {
            this.g.enforceEdge(this.from, this.to, this);
        } else if (this.bool.getUB() == 0) {
            this.g.removeEdge(this.from, this.to, this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.from < 0 || this.from >= this.g.getNbMaxNodes() || this.to < 0 || this.to >= this.g.getNbMaxNodes() || this.bool.getLB() == 1 && !this.g.getPotentialSuccessorsOf(this.from).contains(this.to) || this.bool.getUB() == 0 && this.g.getMandatorySuccessorsOf(this.from).contains(this.to)) {
            return ESat.FALSE;
        }
        if (this.bool.isInstantiated() && this.g.getMandatorySuccessorsOf(this.from).contains(this.to) == this.g.getPotentialSuccessorsOf(this.from).contains(this.to)) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

