// (c) The HDF Group
#ifndef H5Ipublic_H
#define H5Ipublic_H
#include "H5public.h"
//! <!-- [H5I_type_t_snip] -->
typedef enum H5I_type_t {
    H5I_UNINIT = (-2),
    H5I_BADID  = (-1),
    H5I_FILE   = 1,
    H5I_GROUP,
    H5I_DATATYPE,
    H5I_DATASPACE,
    H5I_DATASET,
    H5I_MAP,
    H5I_ATTR,
    H5I_VFL,
    H5I_VOL,
    H5I_GENPROP_CLS,
    H5I_GENPROP_LST,
    H5I_ERROR_CLASS,
    H5I_ERROR_MSG,
    H5I_ERROR_STACK,
    H5I_SPACE_SEL_ITER,
    H5I_EVENTSET,
    H5I_NTYPES
} H5I_type_t;
//! <!-- [H5I_type_t_snip] -->
typedef int64_t hid_t;
#define PRIdHID PRId64
#define PRIxHID PRIx64
#define PRIXHID PRIX64
#define PRIoHID PRIo64
#define H5_SIZEOF_HID_T H5_SIZEOF_INT64_T
#define H5I_INVALID_HID (-1)
typedef herr_t (*H5I_free_t)(void *obj, void **request);
//! <!-- [H5I_search_func_t_snip] -->
typedef int (*H5I_search_func_t)(void *obj, hid_t id, void *key);
//! <!-- [H5I_search_func_t_snip] -->
//! <!-- [H5I_iterate_func_t_snip] -->
typedef herr_t (*H5I_iterate_func_t)(hid_t id, void *udata);
//! <!-- [H5I_iterate_func_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5Iregister(H5I_type_t type, const void *object);
H5_DLL void *H5Iobject_verify(hid_t id, H5I_type_t type);
H5_DLL void *H5Iremove_verify(hid_t id, H5I_type_t type);
H5_DLL H5I_type_t H5Iget_type(hid_t id);
H5_DLL hid_t H5Iget_file_id(hid_t id);
H5_DLL ssize_t H5Iget_name(hid_t id, char *name, size_t size);
H5_DLL int H5Iinc_ref(hid_t id);
H5_DLL int H5Idec_ref(hid_t id);
H5_DLL int H5Iget_ref(hid_t id);
H5_DLL H5I_type_t H5Iregister_type(size_t hash_size, unsigned reserved, H5I_free_t free_func);
H5_DLL herr_t H5Iclear_type(H5I_type_t type, hbool_t force);
H5_DLL herr_t H5Idestroy_type(H5I_type_t type);
H5_DLL int H5Iinc_type_ref(H5I_type_t type);
H5_DLL int H5Idec_type_ref(H5I_type_t type);
H5_DLL int H5Iget_type_ref(H5I_type_t type);
H5_DLL void *H5Isearch(H5I_type_t type, H5I_search_func_t func, void *key);
H5_DLL herr_t H5Iiterate(H5I_type_t type, H5I_iterate_func_t op, void *op_data);
H5_DLL herr_t H5Inmembers(H5I_type_t type, hsize_t *num_members);
H5_DLL htri_t H5Itype_exists(H5I_type_t type);
H5_DLL htri_t H5Iis_valid(hid_t id);
#ifdef __cplusplus
}
#endif
#endif
