// (c) The HDF Group
#ifndef H5HFprivate_H
#define H5HFprivate_H
#include "H5Fprivate.h"
#include "H5Oprivate.h"
#define H5HF_MAX_ID_LEN (4096 + 1)
typedef struct H5HF_dtable_cparam_t {
    unsigned width;
    size_t   start_block_size;
    size_t   max_direct_size;
    unsigned max_index;
    unsigned start_root_rows;
} H5HF_dtable_cparam_t;
typedef struct H5HF_create_t {
    H5HF_dtable_cparam_t managed;
    bool                 checksum_dblocks;
    uint32_t             max_man_size;
    uint16_t id_len;
    H5O_pline_t pline;
} H5HF_create_t;
typedef struct H5HF_stat_t {
    hsize_t man_size;
    hsize_t man_alloc_size;
    hsize_t man_iter_off;
    hsize_t man_free_space;
    hsize_t man_nobjs;
    hsize_t huge_size;
    hsize_t huge_nobjs;
    hsize_t tiny_size;
    hsize_t tiny_nobjs;
} H5HF_stat_t;
typedef struct H5HF_t          H5HF_t;
typedef struct H5HF_hdr_t      H5HF_hdr_t;
typedef struct H5HF_indirect_t H5HF_indirect_t;
typedef herr_t (*H5HF_operator_t)(const void *obj, size_t obj_len, void *op_data);
H5_DLL H5HF_t *H5HF_create(H5F_t *f, const H5HF_create_t *cparam);
H5_DLL H5HF_t *H5HF_open(H5F_t *f, haddr_t fh_addr);
H5_DLL herr_t  H5HF_get_id_len(H5HF_t *fh, size_t *id_len_p);
H5_DLL herr_t  H5HF_get_heap_addr(const H5HF_t *fh, haddr_t *heap_addr);
H5_DLL herr_t  H5HF_insert(H5HF_t *fh, size_t size, const void *obj, void *id);
H5_DLL herr_t  H5HF_get_obj_len(H5HF_t *fh, const void *id, size_t *obj_len_p);
H5_DLL herr_t  H5HF_get_obj_off(H5HF_t *fh, const void *_id, hsize_t *obj_off_p);
H5_DLL herr_t  H5HF_read(H5HF_t *fh, const void *id, void *obj);
H5_DLL herr_t  H5HF_write(H5HF_t *fh, void *id, bool *id_changed, const void *obj);
H5_DLL herr_t  H5HF_op(H5HF_t *fh, const void *id, H5HF_operator_t op, void *op_data);
H5_DLL herr_t  H5HF_remove(H5HF_t *fh, const void *id);
H5_DLL herr_t  H5HF_close(H5HF_t *fh);
H5_DLL herr_t  H5HF_delete(H5F_t *f, haddr_t fh_addr);
H5_DLL herr_t H5HF_stat_info(const H5HF_t *fh, H5HF_stat_t *stats);
H5_DLL herr_t H5HF_size(const H5HF_t *fh, hsize_t *heap_size);
H5_DLL herr_t H5HF_id_print(H5HF_t *fh, const void *id, FILE *stream, int indent, int fwidth);
#ifdef H5HF_DEBUGGING
H5_DLL herr_t H5HF_sects_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth);
#endif
H5_DLL void   H5HF_hdr_print(const H5HF_hdr_t *hdr, bool dump_internal, FILE *stream, int indent, int fwidth);
H5_DLL herr_t H5HF_hdr_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth);
H5_DLL herr_t H5HF_dblock_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth,
                                haddr_t hdr_addr, size_t nrec);
H5_DLL void   H5HF_iblock_print(const H5HF_indirect_t *iblock, bool dump_internal, FILE *stream, int indent,
                                int fwidth);
H5_DLL herr_t H5HF_iblock_debug(H5F_t *f, haddr_t addr, FILE *stream, int indent, int fwidth,
                                haddr_t hdr_addr, unsigned nrows);
#endif
