/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.rosuda.deducer.data.ExDefaultTableModel;
import org.rosuda.deducer.data.ExScrollableTable;
import org.rosuda.deducer.data.ExTable;
import org.rosuda.deducer.models.GLMModel;
import org.rosuda.deducer.toolkit.IconButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class GLMExplorerTests
extends JDialog
implements ListSelectionListener,
ActionListener {
    private JPanel testPanel;
    private JComboBox direction;
    private JLabel directionLabel;
    private JScrollPane testScroller;
    private ExScrollableTable matrixScroller;
    private JPanel okayCancelPanel;
    private JButton removeRow;
    private JButton addRow;
    private JPanel matrixPanel;
    private JButton remove;
    private JButton add;
    private DefaultListModel testModel;
    private JList testList;
    private ExTable matrix;
    private ExDefaultTableModel matrixModel;
    private Vector terms;
    private GLMModel model;

    public GLMExplorerTests(JFrame jFrame, Vector vector, GLMModel gLMModel) {
        super(jFrame);
        this.terms = vector;
        this.setModal(true);
        this.initGUI();
        this.setModel(gLMModel);
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.testPanel = new JPanel();
            Serializable serializable = new BorderLayout();
            this.testPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.testPanel);
            this.testPanel.setBounds(183, 12, 264, 185);
            this.testPanel.setBorder(BorderFactory.createTitledBorder("Hypotheses"));
            this.testScroller = new JScrollPane();
            this.testPanel.add((Component)this.testScroller, "Center");
            this.testModel = new DefaultListModel();
            this.testList = new JList();
            this.testScroller.setViewportView(this.testList);
            this.testList.setModel(this.testModel);
            this.testList.addListSelectionListener(this);
            this.testList.setSelectionMode(0);
            this.add = new IconButton("/icons/edit_add_32.png", "Add", this, "Add");
            this.getContentPane().add(this.add);
            this.add.setBounds(134, 64, 38, 38);
            this.remove = new IconButton("/icons/edit_remove_32.png", "Delete", this, "Delete");
            this.getContentPane().add(this.remove);
            this.remove.setBounds(134, 113, 38, 38);
            this.matrixPanel = new JPanel();
            serializable = new BorderLayout();
            this.matrixPanel.setLayout((LayoutManager)((Object)serializable));
            this.getContentPane().add(this.matrixPanel);
            this.matrixPanel.setBounds(62, 247, 549, 165);
            this.matrixPanel.setBorder(BorderFactory.createTitledBorder("Build Hypothesis"));
            this.matrixModel = new ExDefaultTableModel();
            this.matrix = new ExTable(this.matrixModel);
            this.matrix.getTableHeader().removeMouseListener(this.matrix.getColumnListener());
            this.matrixScroller = new ExScrollableTable(this.matrix);
            this.matrixScroller.removeRowListener();
            this.matrixPanel.add((Component)this.matrixScroller, "Center");
            this.addRow = new IconButton("/icons/edit_add_32.png", "Add row", this, "Add row");
            this.getContentPane().add(this.addRow);
            this.addRow.setBounds(12, 314, 38, 38);
            this.removeRow = new IconButton("/icons/edit_remove_32.png", "Remove last row", this, "Remove last row");
            this.getContentPane().add(this.removeRow);
            this.removeRow.setBounds(12, 358, 38, 38);
            this.okayCancelPanel = new OkayCancelPanel(true, false, this);
            this.getContentPane().add(this.okayCancelPanel);
            this.okayCancelPanel.setBounds(306, 424, 304, 45);
            this.directionLabel = new JLabel();
            this.getContentPane().add(this.directionLabel);
            this.directionLabel.setText("Direction:");
            this.directionLabel.setBounds(183, 203, 72, 14);
            this.directionLabel.setHorizontalAlignment(4);
            serializable = new DefaultComboBoxModel<String>(new String[]{"two.sided", "less", "greater"});
            this.direction = new JComboBox();
            this.getContentPane().add(this.direction);
            this.direction.setModel(serializable);
            this.direction.setBounds(262, 200, 127, 21);
            this.setTitle("Build Hypotheses");
            this.setSize(635, 520);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(GLMModel gLMModel) {
        int n;
        this.model = gLMModel;
        this.direction.setSelectedItem(this.model.tests.direction);
        Object[] objectArray = new String[this.terms.size() + 1];
        for (n = 0; n < this.terms.size(); ++n) {
            objectArray[n] = (String)this.terms.get(n);
        }
        objectArray[this.terms.size()] = "=";
        for (n = 0; n < this.model.tests.size(); ++n) {
            ExDefaultTableModel exDefaultTableModel = this.model.tests.getDuplicateTableModel(n);
            if (exDefaultTableModel.getColumnCount() != this.terms.size() + 1) continue;
            exDefaultTableModel.setColumnIdentifiers(objectArray);
            LHTest lHTest = new LHTest(this.model.tests.getName(n));
            lHTest.hm = exDefaultTableModel;
            this.testModel.addElement(lHTest);
        }
    }

    public void updateModel() {
        this.model.tests.reset();
        this.model.tests.direction = (String)this.direction.getSelectedItem();
        for (int i = 0; i < this.testModel.getSize(); ++i) {
            LHTest lHTest = (LHTest)this.testModel.get(i);
            this.model.tests.addTest(lHTest.name, lHTest.hm);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        LHTest lHTest = (LHTest)this.testList.getSelectedValue();
        if (lHTest != null) {
            this.matrixModel = lHTest.hm;
            this.matrix.setModel(lHTest.hm);
            this.matrixScroller.getRowNamesModel().initHeaders(this.matrixModel.getRowCount());
            this.matrixScroller.getRowNamesModel().refresh();
        } else {
            this.matrixModel = new ExDefaultTableModel();
            this.matrix.setModel(this.matrixModel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            for (int i = 0; i < this.testModel.size(); ++i) {
                LHTest lHTest = (LHTest)this.testModel.get(i);
                if (lHTest.isValid()) continue;
                JOptionPane.showMessageDialog(this, "Hypothesis " + this.testModel.getElementAt(i).toString() + " must contain only numbers, and at least one must be non-zero");
                return;
            }
            this.updateModel();
            this.dispose();
        } else if (string == "Cancel") {
            this.dispose();
        } else if (string == "Reset") {
            this.setModel(this.model);
        } else if (string == "Add") {
            String string2 = JOptionPane.showInputDialog(this, "Name of Hypothesis test:", "hypothesis");
            if (string2 != null && string2 != "") {
                this.testModel.addElement(new LHTest(string2));
            }
        } else if (string == "Delete") {
            if (this.testList.getSelectedIndex() >= 0) {
                this.testModel.remove(this.testList.getSelectedIndex());
            }
        } else if (string == "Add row") {
            if (this.testList.getSelectedIndex() >= 0) {
                int n = this.matrixModel.getColumnCount();
                Object[] objectArray = new String[n];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = "0";
                }
                this.matrixModel.addRow(objectArray);
                this.matrixScroller.getRowNamesModel().initHeaders(this.matrixModel.getRowCount());
                this.matrixScroller.getRowNamesModel().refresh();
            } else {
                String string3 = JOptionPane.showInputDialog(this, "Name of Hypothesis test:", "hypothesis");
                if (string3 != null && string3 != "") {
                    this.testModel.addElement(new LHTest(string3));
                    this.testList.setSelectedIndex(this.testModel.getSize() - 1);
                }
            }
        } else if (string.equals("Remove last row") && this.matrixModel.getRowCount() >= 2) {
            this.matrixModel.setRowCount(this.matrixModel.getRowCount() - 1);
            this.matrixScroller.getRowNamesModel().initHeaders(this.matrixModel.getRowCount());
            this.matrixScroller.getRowNamesModel().refresh();
        }
    }

    class LHTest {
        public String name = "";
        public ExDefaultTableModel hm = new ExDefaultTableModel();

        public LHTest(String string) {
            int n;
            this.name = string;
            for (n = 0; n < GLMExplorerTests.this.terms.size(); ++n) {
                this.hm.addColumn(GLMExplorerTests.this.terms.get(n));
            }
            this.hm.addColumn("=");
            n = this.hm.getColumnCount();
            Object[] objectArray = new String[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = "0";
            }
            this.hm.addRow(objectArray);
        }

        public String toString() {
            return this.name;
        }

        public boolean isValid() {
            boolean bl = true;
            for (int i = 0; i < this.hm.getRowCount(); ++i) {
                for (int j = 0; j < this.hm.getColumnCount(); ++j) {
                    if (!((String)this.hm.getValueAt(i, j)).trim().matches("^[-+]?[0-9]*\\.?[0-9]+$")) {
                        return false;
                    }
                    if (((String)this.hm.getValueAt(i, j)).trim().equals("0")) continue;
                    bl = false;
                }
            }
            return !bl;
        }
    }
}

