/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.gui.experimentertab.Algorithm;
import org.apache.commons.io.FilenameUtils;

public class ReadFile {
    private String path;
    private LinkedList<String> stream;
    private LinkedList<String> algNames;
    private LinkedList<String> measures;
    private ArrayList<String> algShortNames;
    private List<Algorithm> algorithm = new ArrayList<Algorithm>();

    public ReadFile(String path) {
        this.path = path;
        this.stream = new LinkedList();
        this.algNames = new LinkedList();
        this.measures = new LinkedList();
        this.algShortNames = new ArrayList();
    }

    public String processFiles() {
        File file = new File(this.path);
        File[] listFiles = file.listFiles();
        boolean addFirst = true;
        for (int i = 0; i < listFiles.length; ++i) {
            if (!listFiles[i].isDirectory()) continue;
            this.stream.add(listFiles[i].getName());
            File files = new File(listFiles[i].getAbsolutePath());
            File[] algorithm = files.listFiles();
            for (int j = 0; j < algorithm.length; ++j) {
                if (!algorithm[j].isFile()) continue;
                if (this.algNames.remove(algorithm[j].getName())) {
                    this.algNames.add(algorithm[j].getName());
                } else {
                    this.algNames.add(algorithm[j].getName());
                }
                FileReader fr = null;
                try {
                    fr = new FileReader(algorithm[j].getAbsolutePath());
                }
                catch (FileNotFoundException ex) {
                    return "Problem with file: " + listFiles[j].getAbsolutePath();
                }
                BufferedReader br = new BufferedReader(fr);
                try {
                    String line = br.readLine();
                    if (addFirst) {
                        this.measures.add(line);
                        addFirst = false;
                        continue;
                    }
                    if (this.measures.remove(line)) {
                        this.measures.add(line);
                        continue;
                    }
                    String[] lineArray = line.split(",");
                    String[] measureArray = this.measures.getFirst().split(",");
                    String newMeasure = "";
                    for (int l = 0; l < lineArray.length; ++l) {
                        for (int m = 0; m < measureArray.length; ++m) {
                            if (!lineArray[l].equals(measureArray[m])) continue;
                            newMeasure = newMeasure + lineArray[l] + ",";
                        }
                    }
                    if (newMeasure.endsWith(",")) {
                        String[] s = newMeasure.split(",");
                        newMeasure = "";
                        for (int k = 0; k < s.length; ++k) {
                            newMeasure = newMeasure + s[k];
                            if (k == s.length - 1) continue;
                            newMeasure = newMeasure + ",";
                        }
                    }
                    this.measures.removeFirst();
                    this.measures.add(newMeasure);
                    continue;
                }
                catch (IOException ex) {
                    return "Problem with file: " + listFiles[j].getAbsolutePath();
                }
            }
        }
        this.algNames.stream().forEach(algName -> this.algShortNames.add(FilenameUtils.getBaseName((String)algName)));
        return "";
    }

    public String updateMeasures(String[] algNames, String stream) {
        this.measures = new LinkedList();
        boolean addFirst = true;
        for (int i = 0; i < algNames.length; ++i) {
            File algorithm = new File(this.path + File.separator + stream + File.separator + algNames[i]);
            FileReader fr = null;
            try {
                fr = new FileReader(algorithm.getAbsolutePath());
            }
            catch (FileNotFoundException ex) {
                return "Problem with file: " + algorithm.getAbsolutePath();
            }
            BufferedReader br = new BufferedReader(fr);
            try {
                String line = br.readLine();
                if (addFirst) {
                    this.measures.add(line);
                    addFirst = false;
                    continue;
                }
                if (this.measures.remove(line)) {
                    this.measures.add(line);
                    continue;
                }
                String[] lineArray = line.split(",");
                String[] measureArray = this.measures.getFirst().split(",");
                String newMeasure = "";
                for (int l = 0; l < lineArray.length; ++l) {
                    for (int m = 0; m < measureArray.length; ++m) {
                        if (!lineArray[l].equals(measureArray[m])) continue;
                        newMeasure = newMeasure + lineArray[l] + ",";
                    }
                }
                if (newMeasure.endsWith(",")) {
                    String[] s = newMeasure.split(",");
                    newMeasure = "";
                    for (int k = 0; k < s.length; ++k) {
                        newMeasure = newMeasure + s[k];
                        if (k == s.length - 1) continue;
                        newMeasure = newMeasure + ",";
                    }
                }
                this.measures.removeFirst();
                this.measures.add(newMeasure);
                continue;
            }
            catch (IOException ex) {
                return "Problem with file: " + algorithm.getAbsolutePath();
            }
        }
        return null;
    }

    static int getMeasureIndex(String algPath, String mesasure) {
        FileReader fr = null;
        try {
            fr = new FileReader(new File(algPath));
            BufferedReader br = new BufferedReader(fr);
            String line = br.readLine();
            String[] measures = line.split(",");
            for (int i = 0; i < measures.length; ++i) {
                if (!measures[i].equals(mesasure)) continue;
                return i;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ReadFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ReadFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0;
    }

    public LinkedList<String> getAlgNames() {
        return this.algNames;
    }

    public LinkedList<String> getMeasures() {
        return this.measures;
    }

    public LinkedList<String> getStream() {
        return this.stream;
    }

    public ArrayList<String> getAlgShortNames() {
        return this.algShortNames;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public static void deleteDrectory(File directory) {
        File[] files;
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                ReadFile.deleteDrectory(file);
            }
            file.delete();
        }
    }

    public static ArrayList<String[]> readCSV(String path) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        ArrayList<String[]> data = new ArrayList<String[]>();
        try (FileInputStream csv = new FileInputStream(path);
             InputStreamReader reader = new InputStreamReader(csv);
             BufferedReader br = new BufferedReader(reader);){
            String linea = br.readLine();
            while ((linea = br.readLine()) != null) {
                data.add(linea.split(","));
            }
        }
        return data;
    }
}

