/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.logging.Logger;

public class ReaderUtils {
    private ReaderUtils() {
    }

    public static void readFirstToken(StreamTokenizer tokenizer) throws IOException {
        while (tokenizer.nextToken() == 10) {
        }
        if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void readNextToken(StreamTokenizer tokenizer, boolean isEOLSignificant) throws IOException {
        if (tokenizer.nextToken() == 10) {
            if (isEOLSignificant) {
                ReaderUtils.throwError(tokenizer, "premature end of line");
            } else {
                return;
            }
        }
        if (tokenizer.ttype == -1) {
            ReaderUtils.throwError(tokenizer, "premature end of file");
        } else if (tokenizer.ttype == 39 || tokenizer.ttype == 34) {
            tokenizer.ttype = -3;
        } else if (tokenizer.ttype == -3 && tokenizer.sval.equals("?")) {
            tokenizer.ttype = 63;
        }
    }

    public static void throwError(StreamTokenizer tokenizer, String theMsg) throws IOException {
        IOException ex = new IOException(String.valueOf(theMsg) + ", read " + tokenizer.toString());
        Logger.getLogger(ReaderUtils.class.getName()).throwing(ReaderUtils.class.getName(), "throwError", ex);
        throw ex;
    }

    public static void readLastToken(StreamTokenizer tokenizer, boolean endOfFileOk) throws IOException {
        if (!(tokenizer.nextToken() == 10 || tokenizer.ttype == -1 && endOfFileOk)) {
            ReaderUtils.throwError(tokenizer, "end of line expected");
        }
    }
}

