/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.io.FileOutputStream;
import java.io.IOException;
import org.guha.rcdk.view.RcdkDepictor;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;

public class MoleculeImage {
    private IAtomContainer molecule;
    private RcdkDepictor depictor;

    public MoleculeImage(IAtomContainer molecule, RcdkDepictor depictor) throws Exception {
        this.molecule = molecule;
        this.depictor = depictor;
    }

    public byte[] getBytes(int width, int height, String fmt) throws IOException, CDKException {
        this.depictor.setWidth(width);
        this.depictor.setHeight(height);
        return this.depictor.getFormat(this.molecule, fmt);
    }

    public static void main(String[] args) throws Exception {
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer mol = sp.parseSmiles("c1ccccc1CC(=O)C1COCNC1");
        RcdkDepictor depictor = new RcdkDepictor(300, 300, 1.3, "cow", "off", "reagents", true, false, 100, "", false);
        MoleculeImage mi = new MoleculeImage(mol, depictor);
        byte[] bytes = mi.getBytes(300, 300, "png");
        FileOutputStream fos = new FileOutputStream("test.png");
        fos.write(bytes);
    }
}

