/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Planner;

import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.profile.ProfileRequest;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.profile.StreetPath;
import com.conveyal.r5.streets.StreetRouter;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.ipea.r5r.Utils.Utils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;

public class TripLeg {
    private String mode;
    private boolean isTransfer = false;
    private boolean isTransit = false;
    private int legDurationSeconds;
    private int legDistance;
    private int cumulativeFare;
    private int boardStop;
    private int alightStop;
    private int fromStop;
    private int toStop;
    private int boardStopPosition;
    private int alightStopPosition;
    private TripPattern pattern;
    private int waitTime;
    private String route;
    private LineString geometry;

    public void setPatternData(TripPattern pattern, int boardStopPosition, int alightStopPosition) {
        this.pattern = pattern;
        this.boardStopPosition = boardStopPosition;
        this.alightStopPosition = alightStopPosition;
    }

    public void setODStops(int fromStop, int toStop) {
        this.fromStop = fromStop;
        this.toStop = toStop;
    }

    public String getMode() {
        return this.mode;
    }

    public int getLegDurationSeconds() {
        return this.legDurationSeconds;
    }

    public int getLegDistance() {
        return this.legDistance;
    }

    public int getCumulativeFare() {
        return this.cumulativeFare;
    }

    public int getBoardStop() {
        return this.boardStop;
    }

    public int getAlightStop() {
        return this.alightStop;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public String getRoute() {
        return this.route;
    }

    public LineString getGeometry() {
        return this.geometry;
    }

    public static TripLeg newDirectLeg(String mode, StreetSegment streetSegment) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.legDistance = streetSegment.distance;
        newLeg.legDurationSeconds = streetSegment.duration;
        newLeg.cumulativeFare = 0;
        newLeg.route = "";
        newLeg.geometry = streetSegment.geometry;
        return newLeg;
    }

    public static TripLeg newTransferLeg(String mode, int duration, int fare, LineString geometry) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.isTransfer = true;
        newLeg.legDistance = (int)geometry.getLength();
        newLeg.legDurationSeconds = duration;
        newLeg.cumulativeFare = fare;
        newLeg.route = "";
        newLeg.geometry = geometry;
        return newLeg;
    }

    public static TripLeg newTransitLeg(String mode, int duration, int fare, int waitTime, int boardStop, int alightStop, String route) {
        TripLeg newLeg = new TripLeg();
        newLeg.mode = mode;
        newLeg.isTransit = true;
        newLeg.legDurationSeconds = duration;
        newLeg.cumulativeFare = fare;
        newLeg.waitTime = waitTime;
        newLeg.boardStop = boardStop;
        newLeg.alightStop = alightStop;
        newLeg.route = route;
        return newLeg;
    }

    public void augmentTransitLeg(MultiKeyMap<Integer, StreetSegment> transferPaths, TransportNetwork network, ProfileRequest request) {
        if (this.isTransit) {
            ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
            List hops = this.pattern.getHopGeometries(network.transitLayer);
            for (int i = this.boardStopPosition; i < this.alightStopPosition; ++i) {
                LineString hop = (LineString)hops.get(i);
                coords.addAll(Arrays.asList(hop.getCoordinates()));
            }
            this.geometry = GeometryUtils.geometryFactory.createLineString(coords.toArray(new Coordinate[0]));
            this.legDistance = Utils.getLinestringLength(this.geometry);
        } else if (this.fromStop > 0 & this.toStop > 0) {
            StreetSegment streetSegment = (StreetSegment)transferPaths.get((Object)this.fromStop, (Object)this.toStop);
            if (streetSegment == null) {
                boolean prevReverseSearch = request.reverseSearch;
                request.reverseSearch = false;
                StreetRouter streetRouter = new StreetRouter(network.streetLayer);
                streetRouter.streetMode = StreetMode.WALK;
                streetRouter.profileRequest = request;
                streetRouter.distanceLimitMeters = 1000;
                int stopVertexId = network.transitLayer.streetVertexForStop.get(this.fromStop);
                streetRouter.setOrigin(stopVertexId);
                Coordinate destStopCoord = network.transitLayer.getCoordinateForStopFixed(this.toStop);
                streetRouter.setDestination(destStopCoord.getY() / 1.0E7, destStopCoord.getX() / 1.0E7);
                streetRouter.route();
                StreetRouter.State lastState = streetRouter.getState(destStopCoord.getY() / 1.0E7, destStopCoord.getX() / 1.0E7);
                if (lastState != null) {
                    StreetPath streetPath = new StreetPath(lastState, network, false);
                    streetSegment = new StreetSegment(streetPath, LegMode.WALK, network.streetLayer);
                    this.legDurationSeconds = streetSegment.duration;
                    this.geometry = streetSegment.geometry;
                    this.legDistance = Utils.getLinestringLength(this.geometry);
                    transferPaths.put((Object)this.fromStop, (Object)this.toStop, (Object)streetSegment);
                }
                request.reverseSearch = prevReverseSearch;
            } else {
                this.geometry = streetSegment.geometry;
                this.legDistance = Utils.getLinestringLength(this.geometry);
            }
        } else {
            this.legDistance = Utils.getLinestringLength(this.geometry);
        }
    }

    public int augmentDirectLeg() {
        this.legDistance = Utils.getLinestringLength(this.geometry);
        return this.legDistance;
    }
}

