/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.BipartiteIntDomainIterator;
import choco.cp.solver.variables.delta.BipartiteDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import java.util.Arrays;
import java.util.Random;

public class BipartiteIntDomain
extends AbstractIntDomain {
    private static final Random random = new Random();
    private int[] values;
    private IStateInt valuesInDomainNumber;
    private IStateInt inf;
    private IStateInt sup;
    private int[] indices;
    private int offset;
    protected BipartiteIntDomainIterator _iterator = null;

    public BipartiteIntDomain(IntDomainVarImpl v, int[] sortedValues, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        assert (v != null);
        assert (sortedValues != null);
        this.init(sortedValues, environment);
    }

    public BipartiteIntDomain(IntDomainVarImpl v, int low, int up, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        assert (v != null);
        assert (low <= up);
        int[] sortedValues = new int[up - low + 1];
        for (int i = 0; i < sortedValues.length; ++i) {
            sortedValues[i] = low + i;
        }
        this.init(sortedValues, environment);
    }

    void init(int[] sortedValues, IEnvironment environment) {
        int low = sortedValues[0];
        int up = sortedValues[sortedValues.length - 1];
        int size = sortedValues.length;
        this.offset = low;
        this.values = new int[size];
        System.arraycopy(sortedValues, 0, this.values, 0, sortedValues.length);
        this.valuesInDomainNumber = environment.makeInt(size - 1);
        this.indices = new int[up - low + 1];
        Arrays.fill(this.indices, Integer.MAX_VALUE);
        for (int i = 0; i < this.values.length; ++i) {
            this.indices[this.values[i] - this.offset] = i;
        }
        this.deltaDom = new BipartiteDeltaDomain(size, this.values, this.valuesInDomainNumber);
        this.inf = environment.makeInt(low);
        this.sup = environment.makeInt(up);
    }

    @Override
    public int getInf() {
        return this.inf.get();
    }

    @Override
    public int getSup() {
        return this.sup.get();
    }

    @Override
    public boolean contains(int x) {
        return this.indices[x - this.offset] <= this.valuesInDomainNumber.get();
    }

    @Override
    public int getSize() {
        return this.valuesInDomainNumber.get() + 1;
    }

    @Override
    public int getNextValue(int x) {
        if (x >= this.getSup()) {
            return Integer.MAX_VALUE;
        }
        int nextval = Integer.MAX_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] <= x || this.values[i] >= nextval) continue;
            nextval = this.values[i];
        }
        return nextval;
    }

    @Override
    public int getPrevValue(int x) {
        if (x <= this.getInf()) {
            return Integer.MAX_VALUE;
        }
        int prevval = Integer.MIN_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] >= x || this.values[i] <= prevval) continue;
            prevval = this.values[i];
        }
        return prevval;
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public boolean removeInterval(int a, int b, SConstraint cause, boolean forceAwake) throws ContradictionException {
        if (a <= this.getInf()) {
            return this.updateInf(b + 1, cause, forceAwake);
        }
        if (this.getSup() <= b) {
            return this.updateSup(a - 1, cause, forceAwake);
        }
        boolean anyChange = false;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            int v = this.values[i];
            if (v < a || v > b) continue;
            anyChange |= this.removeVal(v, cause, forceAwake);
        }
        return anyChange;
    }

    @Override
    protected boolean _removeVal(int x, SConstraint cause) throws ContradictionException {
        int infv = this.getInf();
        int supv = this.getSup();
        if (infv <= x && x <= supv) {
            boolean b = this.remove(x);
            if (x == infv) {
                int possibleninf = x + 1;
                if (possibleninf > supv) {
                    this.propagationEngine.raiseContradiction(cause);
                }
                int min = Integer.MAX_VALUE;
                for (int i = this.valuesInDomainNumber.get(); i >= 0 && (this.values[i] >= min || (min = this.values[i]) != possibleninf); --i) {
                }
                this.inf.set(min);
                return b;
            }
            if (x == supv) {
                int possiblesup = x - 1;
                if (possiblesup < infv) {
                    this.propagationEngine.raiseContradiction(cause);
                }
                int max = Integer.MIN_VALUE;
                for (int i = this.valuesInDomainNumber.get(); i >= 0 && (this.values[i] <= max || (max = this.values[i]) != possiblesup); --i) {
                }
                this.sup.set(max);
                return b;
            }
            return b;
        }
        return false;
    }

    @Override
    public boolean remove(int x) {
        int i = x - this.offset;
        int mark = this.valuesInDomainNumber.get();
        if (this.indices[i] <= mark) {
            if (this.indices[i] < mark) {
                int tempval = this.values[mark];
                this.values[mark] = x;
                this.values[this.indices[i]] = tempval;
                this.indices[tempval - this.offset] = this.indices[i];
                this.indices[i] = mark;
            }
            this.valuesInDomainNumber.add(-1);
            this.deltaDom.remove(mark);
            return true;
        }
        return false;
    }

    @Override
    public void restrict(int x) {
        int i = x - this.offset;
        int tempval = this.values[0];
        this.values[0] = x;
        this.values[this.indices[i]] = tempval;
        this.indices[tempval - this.offset] = this.indices[i];
        this.indices[i] = 0;
        this.inf.set(x);
        this.sup.set(x);
        this.deltaDom.remove(this.valuesInDomainNumber.get());
        this.valuesInDomainNumber.set(0);
    }

    @Override
    public int updateInf(int x) {
        int min = Integer.MAX_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] < x) {
                this.remove(this.values[i]);
                continue;
            }
            if (this.values[i] >= min) continue;
            min = this.values[i];
        }
        this.inf.set(min);
        return min;
    }

    @Override
    public int updateSup(int x) {
        int max = Integer.MIN_VALUE;
        for (int i = this.valuesInDomainNumber.get(); i >= 0; --i) {
            if (this.values[i] > x) {
                this.remove(this.values[i]);
                continue;
            }
            if (this.values[i] <= max) continue;
            max = this.values[i];
        }
        this.sup.set(max);
        return max;
    }

    @Override
    public int getRandomValue() {
        if (this.getSize() == 1) {
            return this.values[0];
        }
        return this.values[random.nextInt(this.valuesInDomainNumber.get() + 1)];
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new BipartiteIntDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new BipartiteIntDomainIterator();
        }
        this._iterator.init(this.valuesInDomainNumber.get(), this.values);
        return this._iterator;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String pretty() {
        StringBuilder buf = new StringBuilder("{");
        int maxDisplay = 15;
        int count = 1;
        int current = this.getInf();
        buf.append(current);
        while (count < 15 && this.hasNextValue(current)) {
            current = this.getNextValue(current);
            if (++count > 0) {
                buf.append(", ");
            }
            buf.append(current);
        }
        if (this.getSize() > 15) {
            buf.append(", ..., ");
            buf.append(this.getSup());
        }
        buf.append('}');
        return buf.toString();
    }
}

