/*
 * Decompiled with CFR 0.152.
 */
package mrmc.chart;

import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DecimalFormat;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.gui.SizePanel;
import mrmc.gui.StatPanel;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import roemetz.gui.RMGUInterface;

public class exportToFile {
    static DecimalFormat twoDec = new DecimalFormat("0.00");
    static DecimalFormat threeDec = new DecimalFormat("0.000");
    static DecimalFormat fourDec = new DecimalFormat("0.0000");
    static DecimalFormat twoDecE = new DecimalFormat("0.00E0");
    static DecimalFormat threeDecE = new DecimalFormat("0.000E0");
    static DecimalFormat fourDecE = new DecimalFormat("0.0000E0");
    static DecimalFormat fiveDecE = new DecimalFormat("0.00000E0");
    static DecimalFormat eightDecE = new DecimalFormat("0.00000000E0");
    private static String SEPA = ",";
    private static String dot = ". ";
    private String MLEString = "(U-statistics, Not MLE)";
    private String UstatString = "(MLE, Not U-statistics)";
    private static String NAlist = "NA,NA,NA,NA,NA,NA";

    public static String exportStatPanel(String oldReport, DBRecord StatDBRecord, StatPanel processStatPanel) {
        String str = oldReport;
        int useMLE = StatDBRecord.flagMLE;
        String result = processStatPanel.getStatResults();
        String USEtitle = "(U-statistics, Not MLE)";
        if (useMLE == 1) {
            USEtitle = "(MLE, Not U-statistics)";
        }
        str = String.valueOf(str) + "\r\n**********************StatPanel outputs " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + StatDBRecord.recordDesc;
        str = String.valueOf(str) + "Modality A = " + StatDBRecord.modalityA + "\r\n";
        str = String.valueOf(str) + "Modality B = " + StatDBRecord.modalityB + "\r\n";
        str = String.valueOf(str) + "\r\n" + StatDBRecord.getAUCsReaderAvgString(StatDBRecord.selectedMod);
        str = String.valueOf(str) + "\r\nStatistical Tests:\r\n" + result + SEPA;
        return str;
    }

    public static String exportTableBDG(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] BDGdata1 = DBRecord.getBDGTab(DBRecordTable.selectedMod, DBRecordTable.BDG, DBRecordTable.BDGcoeff);
        String analysisMethod = "Ustat";
        if (DBRecordTable.flagMLE == 1) {
            BDGdata1 = DBRecord.getBDGTab(DBRecordTable.selectedMod, DBRecordTable.BDGbias, DBRecordTable.BDGcoeff);
            analysisMethod = "MLE";
        }
        str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_A" + SEPA;
        int i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[0][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_A" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[1][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_B" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[2][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_B" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[3][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[3][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_product" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[4][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[4][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_product" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[5][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[5][7]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[6][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BDGdata1[6][7]);
        str = String.valueOf(str) + "\r\n";
        return str;
    }

    public static String exportTableBCK(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] BCKdata1 = DBRecord.getBCKTab(DBRecordTable.selectedMod, DBRecordTable.BCK, DBRecordTable.BCKcoeff);
        String analysisMethod = "Ustat";
        if (DBRecordTable.flagMLE == 1) {
            BCKdata1 = DBRecord.getBCKTab(DBRecordTable.selectedMod, DBRecordTable.BCKbias, DBRecordTable.BCKcoeff);
            analysisMethod = "MLE";
        }
        str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_A" + SEPA;
        int i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[0][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_A" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[1][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_B" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[2][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_B" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[3][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[3][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "comp_product" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[4][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[4][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff_product" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[5][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[5][6]);
        str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[6][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + fiveDecE.format(BCKdata1[6][6]);
        str = String.valueOf(str) + "\r\n";
        return str;
    }

    public static String exportTableDBM(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] DBMdata1 = DBRecord.getDBMTab(DBRecordTable.selectedMod, DBRecordTable.DBM, DBRecordTable.DBMcoeff);
        String analysisMethod = "Ustat";
        if (DBRecordTable.flagMLE == 1) {
            DBMdata1 = DBRecord.getDBMTab(DBRecordTable.selectedMod, DBRecordTable.DBMbias, DBRecordTable.DBMcoeff);
            analysisMethod = "MLE";
        }
        if (DBRecordTable.flagFullyCrossed) {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA;
            int i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(DBMdata1[0][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[0][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(DBMdata1[1][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[1][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(DBMdata1[2][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[2][5]);
            str = String.valueOf(str) + "\r\n";
        } else {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA + NAlist + "\r\n";
        }
        return str;
    }

    public static String exportTableOR(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] ORdata1 = DBRecord.getORTab(DBRecordTable.selectedMod, DBRecordTable.OR, DBRecordTable.ORcoeff);
        String analysisMethod = "Ustat";
        if (DBRecordTable.flagMLE == 1) {
            ORdata1 = DBRecord.getORTab(DBRecordTable.selectedMod, DBRecordTable.ORbias, DBRecordTable.ORcoeff);
            analysisMethod = "MLE";
        }
        if (DBRecordTable.flagFullyCrossed) {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA;
            int i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(ORdata1[0][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(ORdata1[0][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(ORdata1[1][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(ORdata1[1][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(ORdata1[2][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(ORdata1[2][5]);
            str = String.valueOf(str) + "\r\n";
        } else {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA + NAlist + "\r\n";
        }
        return str;
    }

    public static String exportTableMS(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] MSdata1 = DBRecord.getMSTab(DBRecordTable.selectedMod, DBRecordTable.MS, DBRecordTable.MScoeff);
        String analysisMethod = "Ustat";
        if (DBRecordTable.flagMLE == 1) {
            MSdata1 = DBRecord.getMSTab(DBRecordTable.selectedMod, DBRecordTable.MSbias, DBRecordTable.MScoeff);
            analysisMethod = "MLE";
        }
        if (DBRecordTable.flagFullyCrossed) {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA;
            int i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(MSdata1[0][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(MSdata1[0][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(MSdata1[1][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(MSdata1[1][5]);
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA;
            i = 0;
            while (i < 5) {
                str = String.valueOf(str) + fiveDecE.format(MSdata1[2][i]) + SEPA;
                ++i;
            }
            str = String.valueOf(str) + fiveDecE.format(MSdata1[2][5]);
            str = String.valueOf(str) + "\r\n";
        } else {
            str = String.valueOf(str) + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "components" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "coeff" + SEPA + NAlist;
            str = String.valueOf(str) + "\r\n" + DBRecordTable.modalityA + SEPA + DBRecordTable.modalityB + SEPA + analysisMethod + SEPA + "total" + SEPA + NAlist + "\r\n";
        }
        return str;
    }

    public static String exportTable1(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] BDGdata1 = DBRecord.getBDGTab(DBRecordTable.selectedMod, DBRecordTable.BDG, DBRecordTable.BDGcoeff);
        double[][] BCKdata1 = DBRecord.getBCKTab(DBRecordTable.selectedMod, DBRecordTable.BCK, DBRecordTable.BCKcoeff);
        String USEtitle = "(U-statistics, Not MLE)";
        if (DBRecordTable.flagMLE == 1) {
            BDGdata1 = DBRecord.getBDGTab(DBRecordTable.selectedMod, DBRecordTable.BDGbias, DBRecordTable.BDGcoeff);
            BCKdata1 = DBRecord.getBCKTab(DBRecordTable.selectedMod, DBRecordTable.BCKbias, DBRecordTable.BCKcoeff);
            USEtitle = "(MLE, Not U-statistics)";
        }
        str = String.valueOf(str) + "\r\n**********************BDG output Results " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + "Moments" + SEPA + "M1" + SEPA + "M2" + SEPA + "M3" + SEPA + "M4" + SEPA + "M5" + SEPA + "M6" + SEPA + "M7" + SEPA + "M8";
        str = String.valueOf(str) + "\r\n" + "comp MA" + SEPA;
        int i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff MA" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "comp MB" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff MB" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[3][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "comp product" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[4][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "-coeff product" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[5][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "total" + SEPA;
        i = 0;
        while (i < 8) {
            str = String.valueOf(str) + fiveDecE.format(BDGdata1[6][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        str = String.valueOf(str) + "\r\n**********************BCK output Results " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + "\r\nMoments" + SEPA + "N" + SEPA + "D" + SEPA + "N~D" + SEPA + "R" + SEPA + "N~R" + SEPA + "D~R" + SEPA + "R~N~D";
        str = String.valueOf(str) + "\r\n" + "comp MA" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff MA" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "comp MB" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff MB" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[3][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "comp product" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[4][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "-coeff product" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[5][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "total" + SEPA;
        i = 0;
        while (i < 7) {
            str = String.valueOf(str) + fiveDecE.format(BCKdata1[6][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        return str;
    }

    public static String exportTable2(String oldReport, DBRecord DBRecordTable) {
        String str = oldReport;
        double[][] DBMdata1 = DBRecord.getDBMTab(DBRecordTable.selectedMod, DBRecordTable.DBM, DBRecordTable.DBMcoeff);
        double[][] ORdata1 = DBRecord.getORTab(DBRecordTable.selectedMod, DBRecordTable.OR, DBRecordTable.ORcoeff);
        double[][] MSdata1 = DBRecord.getMSTab(DBRecordTable.selectedMod, DBRecordTable.MS, DBRecordTable.MScoeff);
        String USEtitle = "(U-statistics, Not MLE)";
        if (DBRecordTable.flagMLE == 1) {
            DBMdata1 = DBRecord.getDBMTab(DBRecordTable.selectedMod, DBRecordTable.DBMbias, DBRecordTable.DBMcoeff);
            ORdata1 = DBRecord.getORTab(DBRecordTable.selectedMod, DBRecordTable.ORbias, DBRecordTable.ORcoeff);
            MSdata1 = DBRecord.getMSTab(DBRecordTable.selectedMod, DBRecordTable.MSbias, DBRecordTable.MScoeff);
            USEtitle = "(MLE, Not U-statistics)";
        }
        str = String.valueOf(str) + "\r\n**********************DBM output Results " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + "\r\nComponents" + SEPA + "R" + SEPA + "C" + SEPA + "R~C" + SEPA + "T~R" + SEPA + "T~C" + SEPA + "T~R~C";
        str = String.valueOf(str) + "\r\n" + "components" + SEPA;
        int i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "total" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(DBMdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        str = String.valueOf(str) + "\r\n**********************OR output Results " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + "\r\nComponents" + SEPA + "R" + SEPA + "TR" + SEPA + "COV1" + SEPA + "COV2" + SEPA + "COV3" + SEPA + "ERROR";
        str = String.valueOf(str) + "\r\n" + "components" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(ORdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "coeff" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(ORdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "total" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(ORdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        str = String.valueOf(str) + "\r\n**********************MS output Results " + USEtitle + "***************************\r\n";
        str = String.valueOf(str) + "\r\nComponents" + SEPA + "R" + SEPA + "C" + SEPA + "RC" + SEPA + "MR" + SEPA + "MC" + SEPA + "MRC";
        str = String.valueOf(str) + "\r\ncomponents" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(MSdata1[0][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\ncoeff" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(MSdata1[1][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n" + "total" + SEPA;
        i = 0;
        while (i < 6) {
            str = String.valueOf(str) + fiveDecE.format(MSdata1[2][i]) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        return str;
    }

    public static String exportSizePanel(String oldReport, DBRecord SizeDBRecord, SizePanel processSizePanel) {
        String str = oldReport;
        double[] statParms = new double[]{Double.parseDouble(processSizePanel.SigLevelJTextField.getText()), Double.parseDouble(processSizePanel.EffSizeJTextField.getText())};
        int NreaderSize = Integer.parseInt(processSizePanel.NreaderJTextField.getText());
        int NnormalSize = Integer.parseInt(processSizePanel.NnormalJTextField.getText());
        int NdiseaseSize = Integer.parseInt(processSizePanel.NdiseaseJTextField.getText());
        String resultnew = processSizePanel.exportSizeResults();
        str = String.valueOf(str) + "\r\n*********************Sizing parameters***************************";
        str = String.valueOf(str) + "\r\n" + "Effective Size = " + twoDec.format(statParms[1]) + SEPA + "Significance Level = " + twoDec.format(statParms[0]) + "\r\n";
        str = String.valueOf(str) + "NReaderSize=  " + NreaderSize + SEPA + "NnormalSize=  " + NnormalSize + SEPA + "NDiseaseSize= " + NdiseaseSize + "\r\n";
        str = String.valueOf(str) + "# of split plot= " + processSizePanel.numSplitPlots + "\r\n";
        str = processSizePanel.pairedReadersFlag == 1 ? String.valueOf(str) + "Paired Reader: Yes " + "\r\n" : String.valueOf(str) + "Paired Reader: No " + "\r\n";
        str = processSizePanel.pairedNormalsFlag == 1 ? String.valueOf(str) + "Paired Normal Case: Yes " + "\r\n" : String.valueOf(str) + "Paired Normal Case: No " + "\r\n";
        str = processSizePanel.pairedDiseasedFlag == 1 ? String.valueOf(str) + "Paired Diseaseed Case: Yes " + "\r\n" : String.valueOf(str) + "Paired Diseaseed Case: No " + "\r\n";
        str = String.valueOf(str) + "\r\n*****************************************************************";
        str = String.valueOf(str) + "\r\nSizing Results:\r\n";
        str = String.valueOf(str) + resultnew;
        str = String.valueOf(str) + "\r\n*****************************************************************\r\n";
        return str;
    }

    public static String exportSizeCsv(String report, DBRecord SizeDBRecord, SizePanel processSizePanel, String timestring) {
        String str = report;
        double[] statParms = new double[]{Double.parseDouble(processSizePanel.SigLevelJTextField.getText()), Double.parseDouble(processSizePanel.EffSizeJTextField.getText())};
        String inputfilename = SizeDBRecord.InputFile1.fileName;
        str = String.valueOf(str) + inputfilename + SEPA;
        str = String.valueOf(str) + timestring + SEPA;
        str = String.valueOf(str) + "iMRMC Version 4.0.3" + SEPA;
        str = String.valueOf(str) + SizeDBRecord.modalityA + SEPA;
        str = String.valueOf(str) + SizeDBRecord.modalityB + SEPA;
        str = String.valueOf(str) + Integer.parseInt(processSizePanel.NreaderJTextField.getText()) + SEPA;
        str = String.valueOf(str) + Integer.parseInt(processSizePanel.NnormalJTextField.getText()) + SEPA;
        str = String.valueOf(str) + Integer.parseInt(processSizePanel.NdiseaseJTextField.getText()) + SEPA;
        str = String.valueOf(str) + processSizePanel.numSplitPlots + SEPA;
        str = String.valueOf(str) + twoDec.format(statParms[1]) + SEPA;
        str = String.valueOf(str) + twoDec.format(statParms[0]) + SEPA;
        str = SizeDBRecord.flagMLE == 1 ? String.valueOf(str) + "MLE" + SEPA : String.valueOf(str) + "Ustat" + SEPA;
        String tempstr = "";
        tempstr = processSizePanel.SizeJLabelPowerNormal.getText();
        str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + SEPA;
        tempstr = processSizePanel.SizeJLabelDFBDG.getText();
        str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + SEPA;
        tempstr = processSizePanel.SizeJLabelSqrtVar.getText();
        str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + SEPA;
        tempstr = processSizePanel.SizeJLabelPowerBDG.getText();
        str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + SEPA;
        if (SizeDBRecord.flagFullyCrossed) {
            tempstr = processSizePanel.SizeJLabelDFHillis.getText();
            str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + SEPA;
            tempstr = processSizePanel.SizeJLabelPowerHillis.getText();
            str = String.valueOf(str) + tempstr.substring(tempstr.lastIndexOf("=") + 1) + "\r\n";
        } else {
            str = String.valueOf(str) + "NA,NA" + "\r\n";
        }
        return str;
    }

    public static String exportMCvariance(String oldReport, DBRecord VarDBRecord) {
        String str = oldReport;
        double mcVarAUC_A = VarDBRecord.AUCsReaderAvg[0];
        double mcVarAUC_B = VarDBRecord.AUCsReaderAvg[1];
        double mcVarAUC_AminusB = VarDBRecord.AUCsReaderAvg[2];
        double sqrtMCvarAUC_A = Math.sqrt(mcVarAUC_A);
        double sqrtMCvarAUC_B = Math.sqrt(mcVarAUC_B);
        double sqrtMCvarAUC_AminusB = Math.sqrt(mcVarAUC_AminusB);
        str = String.valueOf(str) + "\r\n**********************MC Variance Results***************************\r\n";
        str = String.valueOf(str) + "      mcVarAUC_A = " + fourDecE.format(mcVarAUC_A) + "," + "      sqrtMCvarAUC_A = " + fourDecE.format(sqrtMCvarAUC_A) + "\r\n";
        str = String.valueOf(str) + "      mcVarAUC_B = " + fourDecE.format(mcVarAUC_B) + "," + "      sqrtMCvarAUC_B = " + fourDecE.format(sqrtMCvarAUC_B) + "\r\n";
        str = String.valueOf(str) + "mcVarAUC_AminusB = " + fourDecE.format(mcVarAUC_AminusB) + "," + "sqrtMCvarAUC_AminusB = " + fourDecE.format(sqrtMCvarAUC_AminusB) + "\r\n";
        return str;
    }

    public static String exportSummary(String oldReport, DBRecord SummaryDBRecord) {
        int i;
        String Rdisease;
        String Rnormal;
        String str = oldReport;
        str = String.valueOf(str) + "BEGIN SUMMARY\r\n";
        str = String.valueOf(str) + "NReader=  " + SummaryDBRecord.NreaderDB + "\r\n";
        str = String.valueOf(str) + "Nnormal=  " + SummaryDBRecord.NnormalDB + "\r\n";
        str = String.valueOf(str) + "NDisease= " + SummaryDBRecord.NdiseaseDB + "\r\n" + "\r\n";
        str = String.valueOf(str) + "Modality A = " + SummaryDBRecord.modalityA + "\r\n";
        str = String.valueOf(str) + "Modality B = " + SummaryDBRecord.modalityB + "\r\n" + "\r\n";
        str = String.valueOf(str) + "Reader-Averaged AUCs" + "\r\n";
        str = String.valueOf(str) + SummaryDBRecord.getAUCsReaderAvgString(SummaryDBRecord.selectedMod).replaceAll(",   ", "\r\n") + "\r\n" + "\r\n";
        str = String.valueOf(str) + "Reader Specific AUCs" + "\r\n";
        int k = 0;
        int IDlength = 0;
        for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
            IDlength = Math.max(IDlength, desc_temp.length());
        }
        if (SummaryDBRecord.selectedMod == 0 || SummaryDBRecord.selectedMod == 3) {
            str = String.valueOf(str) + "MOD A" + "\r\n";
            if (IDlength > 9) {
                int i2 = 0;
                while (i2 < IDlength - 9) {
                    str = String.valueOf(str) + " ";
                    ++i2;
                }
                str = String.valueOf(str) + "Reader ID";
                str = String.valueOf(str) + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            } else {
                str = String.valueOf(str) + "Reader ID" + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            }
            k = 0;
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                str = String.valueOf(str) + "\r\n";
                int i3 = 0;
                while (i3 < Math.max(IDlength, 9) - desc_temp.length()) {
                    str = String.valueOf(str) + " ";
                    ++i3;
                }
                str = String.valueOf(str) + desc_temp + SEPA;
                Rnormal = Integer.toString(SummaryDBRecord.N0perReader[k][0]);
                int i4 = 0;
                while (i4 < 13 - Rnormal.length()) {
                    str = String.valueOf(str) + " ";
                    ++i4;
                }
                str = String.valueOf(str) + Rnormal + SEPA;
                Rdisease = Integer.toString(SummaryDBRecord.N1perReader[k][0]);
                i = 0;
                while (i < 14 - Rdisease.length()) {
                    str = String.valueOf(str) + " ";
                    ++i;
                }
                str = String.valueOf(str) + Rdisease;
                str = String.valueOf(str) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.AUCs[k][0]) || SummaryDBRecord.AUCs[k][0] < 0.0 ? "        NA" : fiveDecE.format(SummaryDBRecord.AUCs[k][0])) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.readerVarA[k]) ? "        NA" : fiveDecE.format(Math.sqrt(SummaryDBRecord.readerVarA[k])));
                ++k;
            }
            str = String.valueOf(str) + "\r\n";
        }
        if (SummaryDBRecord.selectedMod == 1 || SummaryDBRecord.selectedMod == 3) {
            str = String.valueOf(str) + "MOD B" + "\r\n";
            if (IDlength > 9) {
                int i5 = 0;
                while (i5 < IDlength - 9) {
                    str = String.valueOf(str) + " ";
                    ++i5;
                }
                str = String.valueOf(str) + "Reader ID";
                str = String.valueOf(str) + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            } else {
                str = String.valueOf(str) + "Reader ID" + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            }
            k = 0;
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                str = String.valueOf(str) + "\r\n";
                int i6 = 0;
                while (i6 < Math.max(IDlength, 9) - desc_temp.length()) {
                    str = String.valueOf(str) + " ";
                    ++i6;
                }
                str = String.valueOf(str) + desc_temp + SEPA;
                Rnormal = Integer.toString(SummaryDBRecord.N0perReader[k][1]);
                int i7 = 0;
                while (i7 < 13 - Rnormal.length()) {
                    str = String.valueOf(str) + " ";
                    ++i7;
                }
                str = String.valueOf(str) + Rnormal + SEPA;
                Rdisease = Integer.toString(SummaryDBRecord.N1perReader[k][1]);
                i = 0;
                while (i < 14 - Rdisease.length()) {
                    str = String.valueOf(str) + " ";
                    ++i;
                }
                str = String.valueOf(str) + Rdisease;
                str = String.valueOf(str) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.AUCs[k][1]) || SummaryDBRecord.AUCs[k][1] < 0.0 ? "        NA" : fiveDecE.format(SummaryDBRecord.AUCs[k][1])) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.readerVarB[k]) ? "       NaN" : fiveDecE.format(Math.sqrt(SummaryDBRecord.readerVarB[k])));
                ++k;
            }
            str = String.valueOf(str) + "\r\n";
        }
        if (SummaryDBRecord.selectedMod == 3) {
            str = String.valueOf(str) + "Difference between MODs A and B" + "\r\n";
            if (IDlength > 9) {
                int i8 = 0;
                while (i8 < IDlength - 9) {
                    str = String.valueOf(str) + " ";
                    ++i8;
                }
                str = String.valueOf(str) + "Reader ID";
                str = String.valueOf(str) + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            } else {
                str = String.valueOf(str) + "Reader ID" + SEPA + "  Normal_Case" + SEPA + "  Disease_Case" + SEPA + "         AUC" + SEPA + "      STDAUC";
            }
            k = 0;
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                str = String.valueOf(str) + "\r\n";
                int i9 = 0;
                while (i9 < Math.max(IDlength, 9) - desc_temp.length()) {
                    str = String.valueOf(str) + " ";
                    ++i9;
                }
                str = String.valueOf(str) + desc_temp + SEPA;
                Rnormal = Integer.toString(SummaryDBRecord.N0perReader[k][2]);
                int i10 = 0;
                while (i10 < 13 - Rnormal.length()) {
                    str = String.valueOf(str) + " ";
                    ++i10;
                }
                str = String.valueOf(str) + Rnormal + SEPA;
                Rdisease = Integer.toString(SummaryDBRecord.N1perReader[k][2]);
                int i11 = 0;
                while (i11 < 14 - Rdisease.length()) {
                    str = String.valueOf(str) + " ";
                    ++i11;
                }
                str = String.valueOf(str) + Rdisease;
                double AUC_dif = SummaryDBRecord.AUCs[k][0] - SummaryDBRecord.AUCs[k][1];
                if (SummaryDBRecord.AUCs[k][1] < 0.0 || SummaryDBRecord.AUCs[k][0] < 0.0) {
                    AUC_dif = Double.NaN;
                }
                str = String.valueOf(str) + SEPA;
                str = AUC_dif < 0.0 ? String.valueOf(str) + " " + (Double.isNaN(AUC_dif) ? "       NA" : fiveDecE.format(AUC_dif)) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.readerTotalVar[k]) ? "       NaN" : fiveDecE.format(Math.sqrt(SummaryDBRecord.readerTotalVar[k]))) : (AUC_dif > 0.0 ? String.valueOf(str) + "  " + (Double.isNaN(AUC_dif) ? "       NA" : fiveDecE.format(AUC_dif)) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.readerTotalVar[k]) ? "       NaN" : fiveDecE.format(Math.sqrt(SummaryDBRecord.readerTotalVar[k]))) : String.valueOf(str) + "   " + (Double.isNaN(AUC_dif) ? "       NA" : fiveDecE.format(AUC_dif)) + SEPA + "  " + (Double.isNaN(SummaryDBRecord.readerTotalVar[k]) ? "       NaN" : fiveDecE.format(Math.sqrt(SummaryDBRecord.readerTotalVar[k]))));
                ++k;
            }
            str = String.valueOf(str) + "\r\n";
        }
        str = String.valueOf(str) + "\r\n**********************BDG Moments***************************\r\n";
        str = String.valueOf(str) + "         Moments" + SEPA + "         M1" + SEPA + "         M2" + SEPA + "         M3" + SEPA + "         M4" + SEPA + "         M5" + SEPA + "         M6" + SEPA + "         M7" + SEPA + "         M8" + "\r\n";
        str = String.valueOf(str) + "Modality1(AUC_A)" + SEPA;
        int i12 = 0;
        while (i12 < 8) {
            str = SummaryDBRecord.BDG[0][i12] > 0.0 ? String.valueOf(str) + " " + fiveDecE.format(SummaryDBRecord.BDG[0][i12]) + SEPA : String.valueOf(str) + "  " + fiveDecE.format(SummaryDBRecord.BDG[0][i12]) + SEPA;
            ++i12;
        }
        str = String.valueOf(str) + "\r\n" + "Modality2(AUC_B)" + SEPA;
        i12 = 0;
        while (i12 < 8) {
            str = SummaryDBRecord.BDG[1][i12] > 0.0 ? String.valueOf(str) + " " + fiveDecE.format(SummaryDBRecord.BDG[1][i12]) + SEPA : String.valueOf(str) + "  " + fiveDecE.format(SummaryDBRecord.BDG[1][i12]) + SEPA;
            ++i12;
        }
        str = String.valueOf(str) + "\r\n" + "    comp product" + SEPA;
        i12 = 0;
        while (i12 < 8) {
            str = SummaryDBRecord.BDG[2][i12] > 0.0 ? String.valueOf(str) + " " + fiveDecE.format(SummaryDBRecord.BDG[2][i12]) + SEPA : String.valueOf(str) + "  " + fiveDecE.format(SummaryDBRecord.BDG[2][i12]) + SEPA;
            ++i12;
        }
        str = String.valueOf(str) + "\r\n";
        str = String.valueOf(str) + "END SUMMARY \r\n";
        return str;
    }

    public static String pdfResult1(String oldReport, DBRecord SummaryDBRecord) {
        String str = oldReport;
        str = String.valueOf(str) + "The data analyzed are based on " + SummaryDBRecord.NreaderDB + " readers scoring " + SummaryDBRecord.NnormalDB + " signal-absent cases and " + SummaryDBRecord.NdiseaseDB + " signal-present cases ";
        str = SummaryDBRecord.selectedMod == 0 ? String.valueOf(str) + "in modality A (named \"" + SummaryDBRecord.modalityA + "\" in input file). " : (SummaryDBRecord.selectedMod == 1 ? String.valueOf(str) + "in modality B (named \"" + SummaryDBRecord.modalityB + "\" in input file). " : String.valueOf(str) + "in modalities A (named \"" + SummaryDBRecord.modalityA + "\" in input file) and B (named \"" + SummaryDBRecord.modalityB + "\" in input file). ");
        str = SummaryDBRecord.flagMLE == 0 ? String.valueOf(str) + "In the table below we show the non-parametric (U-statistic) AUC of each reader and the single-reader estimate of standard error. " + "The last row shows the reader-averaged AUC and the MRMC estimate of standard error based on U-statistics [1,2,3]. " : String.valueOf(str) + "In the table below we show the non-parametric (MLE) AUC of each reader and the single-reader estimate of standard error. " + "The last row shows the reader-averaged AUC and the MRMC estimate of standard error based on MLE [1,2,3]. ";
        if (SummaryDBRecord.selectedMod == 3) {
            str = String.valueOf(str) + "In the last table, the number of signal-absent and signal-present cases shown correspond to the number of cases read in both modalities.* ";
        }
        str = SummaryDBRecord.flagFullyCrossed ? String.valueOf(str) + "The study design was fully crossed. " : String.valueOf(str) + "The study design was not fully crossed. ";
        str = String.valueOf(str) + "When the study design is not fully crossed, we use an extension that can treat arbitrary study designs [3,4].";
        str = String.valueOf(str) + "\r\n" + "\r\n";
        return str;
    }

    public static String pdfResult2(DBRecord SummaryDBRecord) {
        String str = "";
        str = String.valueOf(str) + "Consider the following hypothesis test: " + "\r\n" + "\r\n";
        if (SummaryDBRecord.selectedMod == 0) {
            str = String.valueOf(str) + "H0: AUC(ModalityA) equals 0.5," + "\r\n";
            str = String.valueOf(str) + "H1: AUC(ModalityA) does not equal 0.5. " + "\r\n" + "\r\n";
        } else if (SummaryDBRecord.selectedMod == 1) {
            str = String.valueOf(str) + "H0: AUC(ModalityB) equals 0.5," + "\r\n";
            str = String.valueOf(str) + "H1: AUC(ModalityB) does not equal 0.5. " + "\r\n" + "\r\n";
        } else {
            str = String.valueOf(str) + "H0: AUC(ModalityA) equals AUC(ModalityB)," + "\r\n";
            str = String.valueOf(str) + "H1: AUC(ModalityA) does not equal AUC(ModalityB)," + "\r\n" + "\r\n";
        }
        str = SummaryDBRecord.testStat.rejectBDG == 1.0 ? String.valueOf(str) + "For the hypothesis test above at 95% significance, we reject the null hypothesis " : String.valueOf(str) + "For the hypothesis test above at 95% significance, we cannot reject the null hypothesis ";
        str = SummaryDBRecord.selectedMod == 0 ? String.valueOf(str) + "that the AUC of Modality A is equal to 0.5: " : (SummaryDBRecord.selectedMod == 1 ? String.valueOf(str) + "that the AUC of Modality B is equal to 0.5: " : String.valueOf(str) + "that the AUCs of the two modalities are equal: ");
        str = String.valueOf(str) + "p-value = " + twoDec.format(SummaryDBRecord.testStat.pValBDG) + ", Confidence Interval = [" + twoDec.format(SummaryDBRecord.testStat.ciBotBDG) + " , " + twoDec.format(SummaryDBRecord.testStat.ciTopBDG) + "]. ";
        str = SummaryDBRecord.selectedMod == 0 ? String.valueOf(str) + "This result is based on the t-statistic = " + twoDec.format((SummaryDBRecord.AUCsReaderAvg[0] - 0.5) / SummaryDBRecord.SE) + ", " : (SummaryDBRecord.selectedMod == 1 ? String.valueOf(str) + "This result is based on the t-statistic = " + twoDec.format((SummaryDBRecord.AUCsReaderAvg[1] - 0.5) / SummaryDBRecord.SE) + ", " : String.valueOf(str) + "This result is based on the t-statistic = " + twoDec.format((SummaryDBRecord.AUCsReaderAvg[0] - SummaryDBRecord.AUCsReaderAvg[1]) / SummaryDBRecord.SE) + ", ");
        str = SummaryDBRecord.flagMLE == 0 ? String.valueOf(str) + "each estimated by U-statistics as above. " : String.valueOf(str) + "each estimated by MLE as above. ";
        str = String.valueOf(str) + "The degrees of freedom of this t-statistic are estimated by an equation motivated by the Satterthwaite approximation [3,5,6]." + "\r\n" + "\r\n";
        str = String.valueOf(str) + "   1.\tGallas, B. D. (2006), 'One-Shot Estimate of MRMC Variance: AUC.' Acad Radiol, Vol. 13, (3), 353-362." + "\r\n";
        str = String.valueOf(str) + "   2.\tGallas, B. D.; Bandos, A.; Samuelson, F. & Wagner, R. F. (2009), 'A Framework for Random-Effects ROC Analysis: Biases with the Bootstrap and Other Variance Estimators.' Commun Stat A-Theory, Vol. 38, (15), 2586-2603." + "\r\n";
        str = String.valueOf(str) + "   3.\tGallas, B. D. (2013), 'iMRMC v2p8 Application for Analyzing and Sizing MRMC Reader Studies.', Division of Imaging and Applied Mathematics, CDRH, FDA, Silver Spring, MD, https://github.com/DIDSR/iMRMC/releases." + "\r\n";
        str = String.valueOf(str) + "   4.\tGallas, B. D. & Brown, D. G. (2008), 'Reader Studies for Validation of CAD Systems.' Neural Networks Special Conference Issue, Vol. 21, (2-3), 387-397." + "\r\n";
        str = String.valueOf(str) + "   5.\tSatterthwaite, F. E. (1941), 'Synthesis of Variance.' Psychometrika, Vol. 6, 309-316." + "\r\n";
        str = String.valueOf(str) + "   6.\tObuchowski, N.; Gallas, B. D. & Hillis, S. L. (2012), 'Multi-Reader ROC Studies with Split-Plot Designs: A Comparison of Statistical Methods.' Acad Radiol, Vol. 19, (12), 1508-1517." + "\r\n";
        return str;
    }

    public static PdfPTable[] pdfTable(PdfPTable[] AUCtable, DBRecord SummaryDBRecord) {
        int i;
        int averageDisease;
        int averageNormal;
        int count;
        PdfPCell titlecell;
        if (SummaryDBRecord.selectedMod == 0 || SummaryDBRecord.selectedMod == 3) {
            titlecell = new PdfPCell(new Paragraph("Modality A"));
            titlecell.setColspan(5);
            titlecell.setHorizontalAlignment(1);
            AUCtable[0].addCell(titlecell);
            AUCtable[0].addCell("Reader ID");
            count = 1;
            averageNormal = 0;
            averageDisease = 0;
            AUCtable[0].addCell("# of signal-absent");
            AUCtable[0].addCell("# of signal-present");
            AUCtable[0].addCell("AUC");
            AUCtable[0].addCell("AUC_SE");
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                AUCtable[0].addCell(desc_temp);
                AUCtable[0].addCell(Integer.toString(SummaryDBRecord.N0perReader[count - 1][0]));
                AUCtable[0].addCell(Integer.toString(SummaryDBRecord.N1perReader[count - 1][0]));
                AUCtable[0].addCell(twoDec.format(SummaryDBRecord.AUCs[count - 1][0]));
                AUCtable[0].addCell(SummaryDBRecord.readerVarA[count - 1] >= 0.0 ? twoDecE.format(Math.sqrt(SummaryDBRecord.readerVarA[count - 1])) : "NaN");
                averageNormal += SummaryDBRecord.N0perReader[count - 1][0];
                averageDisease += SummaryDBRecord.N1perReader[count - 1][0];
                ++count;
            }
            i = 0;
            while (i < 5) {
                AUCtable[0].addCell(" ");
                ++i;
            }
            averageNormal = (int)((long)averageNormal / SummaryDBRecord.Nreader);
            averageDisease = (int)((long)averageDisease / SummaryDBRecord.Nreader);
            AUCtable[0].addCell("Average");
            AUCtable[0].addCell(Integer.toString(averageNormal));
            AUCtable[0].addCell(Integer.toString(averageDisease));
            AUCtable[0].addCell(twoDec.format(SummaryDBRecord.AUCsReaderAvg[0]));
            AUCtable[0].addCell(SummaryDBRecord.varA >= 0.0 ? twoDecE.format(Math.sqrt(SummaryDBRecord.varA)) : "NaN");
        }
        if (SummaryDBRecord.selectedMod == 1 || SummaryDBRecord.selectedMod == 3) {
            titlecell = new PdfPCell(new Paragraph("Modality B"));
            titlecell.setColspan(5);
            titlecell.setHorizontalAlignment(1);
            AUCtable[1].addCell(titlecell);
            AUCtable[1].addCell("Reader ID");
            count = 1;
            averageNormal = 0;
            averageDisease = 0;
            AUCtable[1].addCell("# of signal-absent");
            AUCtable[1].addCell("# of signal-present");
            AUCtable[1].addCell("AUC");
            AUCtable[1].addCell("AUC_SE");
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                AUCtable[1].addCell(desc_temp);
                AUCtable[1].addCell(Integer.toString(SummaryDBRecord.N0perReader[count - 1][1]));
                AUCtable[1].addCell(Integer.toString(SummaryDBRecord.N1perReader[count - 1][1]));
                AUCtable[1].addCell(twoDec.format(SummaryDBRecord.AUCs[count - 1][1]));
                AUCtable[1].addCell(SummaryDBRecord.readerVarB[count - 1] >= 0.0 ? twoDecE.format(Math.sqrt(SummaryDBRecord.readerVarB[count - 1])) : "NaN");
                averageNormal += SummaryDBRecord.N0perReader[count - 1][1];
                averageDisease += SummaryDBRecord.N1perReader[count - 1][1];
                ++count;
            }
            i = 0;
            while (i < 5) {
                AUCtable[1].addCell(" ");
                ++i;
            }
            averageNormal = (int)((long)averageNormal / SummaryDBRecord.Nreader);
            averageDisease = (int)((long)averageDisease / SummaryDBRecord.Nreader);
            AUCtable[1].addCell("Average");
            AUCtable[1].addCell(Integer.toString(averageNormal));
            AUCtable[1].addCell(Integer.toString(averageDisease));
            AUCtable[1].addCell(twoDec.format(SummaryDBRecord.AUCsReaderAvg[1]));
            AUCtable[1].addCell(SummaryDBRecord.varB >= 0.0 ? twoDecE.format(Math.sqrt(SummaryDBRecord.varB)) : "NaN");
        }
        if (SummaryDBRecord.selectedMod == 3) {
            titlecell = new PdfPCell(new Paragraph("Difference between modalities A and B"));
            titlecell.setColspan(5);
            titlecell.setHorizontalAlignment(1);
            AUCtable[2].addCell(titlecell);
            AUCtable[2].addCell("Reader ID");
            count = 1;
            averageNormal = 0;
            averageDisease = 0;
            AUCtable[2].addCell("# of signal-absent*");
            AUCtable[2].addCell("# of signal-present*");
            AUCtable[2].addCell("AUC");
            AUCtable[2].addCell("AUC_SE");
            for (String desc_temp : SummaryDBRecord.InputFile1.readerIDs.keySet()) {
                AUCtable[2].addCell(desc_temp);
                AUCtable[2].addCell(Integer.toString(SummaryDBRecord.N0perReader[count - 1][2]));
                AUCtable[2].addCell(Integer.toString(SummaryDBRecord.N1perReader[count - 1][2]));
                AUCtable[2].addCell(twoDec.format(SummaryDBRecord.AUCs[count - 1][2]));
                AUCtable[2].addCell(twoDecE.format(Math.sqrt(SummaryDBRecord.readerTotalVar[count - 1])));
                averageNormal += SummaryDBRecord.N0perReader[count - 1][2];
                averageDisease += SummaryDBRecord.N1perReader[count - 1][2];
                ++count;
            }
            int i2 = 0;
            while (i2 < 5) {
                AUCtable[2].addCell(" ");
                ++i2;
            }
            averageNormal = (int)((long)averageNormal / SummaryDBRecord.Nreader);
            averageDisease = (int)((long)averageDisease / SummaryDBRecord.Nreader);
            AUCtable[2].addCell("Average");
            AUCtable[2].addCell(Integer.toString(averageNormal));
            AUCtable[2].addCell(Integer.toString(averageDisease));
            AUCtable[2].addCell(twoDec.format(SummaryDBRecord.AUCsReaderAvg[0] - SummaryDBRecord.AUCsReaderAvg[1]));
            AUCtable[2].addCell(twoDecE.format(Math.sqrt(SummaryDBRecord.totalVar)));
        }
        return AUCtable;
    }

    public static String exoprtiRoeMetzSet(String oldReport, SizePanel sizePanelRoeMetz) {
        String str = oldReport;
        str = String.valueOf(str) + "\r\n*******************iRoeMetz parameter************************\r\n";
        str = String.valueOf(str) + "u_A: " + RMGUInterface.mu0.getText() + ",     ";
        str = String.valueOf(str) + "u_B: " + RMGUInterface.mu1.getText() + "\n";
        str = String.valueOf(str) + "Input Variances Invariant to Modality: " + "\n";
        str = String.valueOf(str) + "R0: " + RMGUInterface.v_R0.getText() + ",    ";
        str = String.valueOf(str) + "C0: " + RMGUInterface.v_C0.getText() + ",    ";
        str = String.valueOf(str) + "RC0: " + RMGUInterface.v_RC0.getText() + ",    ";
        str = String.valueOf(str) + "R1: " + RMGUInterface.v_R1.getText() + ",    ";
        str = String.valueOf(str) + "C1: " + RMGUInterface.v_C1.getText() + ",    ";
        str = String.valueOf(str) + "RC1: " + RMGUInterface.v_RC1.getText() + "\n";
        str = String.valueOf(str) + "Input Variances Specific to Modality A: " + "\n";
        str = String.valueOf(str) + "AR0: " + RMGUInterface.v_AR0.getText() + ",   ";
        str = String.valueOf(str) + "AC0: " + RMGUInterface.v_AC0.getText() + ",   ";
        str = String.valueOf(str) + "ARC0: " + RMGUInterface.v_ARC0.getText() + ",   ";
        str = String.valueOf(str) + "AR1: " + RMGUInterface.v_AR1.getText() + ",   ";
        str = String.valueOf(str) + "AC1: " + RMGUInterface.v_AC1.getText() + ",   ";
        str = String.valueOf(str) + "ARC1: " + RMGUInterface.v_ARC1.getText() + "\n";
        str = String.valueOf(str) + "Input Variances Specific to Modality B: " + "\n";
        str = String.valueOf(str) + "BR0: " + RMGUInterface.v_BR0.getText() + ",   ";
        str = String.valueOf(str) + "BC0: " + RMGUInterface.v_BC0.getText() + ",   ";
        str = String.valueOf(str) + "BRC0: " + RMGUInterface.v_BRC0.getText() + ",   ";
        str = String.valueOf(str) + "BR1 " + RMGUInterface.v_BR1.getText() + ",   ";
        str = String.valueOf(str) + "BC1: " + RMGUInterface.v_BC1.getText() + ",   ";
        str = String.valueOf(str) + "BRC1: " + RMGUInterface.v_BRC1.getText() + "\n";
        str = String.valueOf(str) + "Input Experiment Size: " + "\n";
        str = String.valueOf(str) + "N0: " + RMGUInterface.NnormalJTextField.getText() + ",   ";
        str = String.valueOf(str) + "N1: " + RMGUInterface.NdiseaseJTextField.getText() + ",   ";
        str = String.valueOf(str) + "NR: " + RMGUInterface.NreaderJTextField.getText() + "\n";
        str = String.valueOf(str) + "Study Design: " + "\n";
        str = String.valueOf(str) + "# of Split-Plot Groups: " + sizePanelRoeMetz.numSplitPlots + ",  ";
        str = String.valueOf(str) + "Random Stream: " + Integer.toString(RMGUInterface.RandomStreamID) + ",  ";
        str = sizePanelRoeMetz.pairedReadersFlag == 1 ? String.valueOf(str) + "Paired Readers: Yes,  " : String.valueOf(str) + "Paired Readers: No,  ";
        str = sizePanelRoeMetz.pairedNormalsFlag == 1 ? String.valueOf(str) + "Paired Normal: Yes,  " : String.valueOf(str) + "Paired Normal: No,  ";
        str = sizePanelRoeMetz.pairedDiseasedFlag == 1 ? String.valueOf(str) + "Paired Diesase: Yes \n" : String.valueOf(str) + "Paired Diesase: No \n";
        return str;
    }

    public static String exportMCmeanValidation(String oldReport, DBRecord VldDBRecord) {
        String str = oldReport;
        double AUC_A = VldDBRecord.AUCsReaderAvg[0];
        double AUC_B = VldDBRecord.AUCsReaderAvg[1];
        double AUC_AminusAUC_B = AUC_A - AUC_B;
        double totalVar = VldDBRecord.totalVar;
        double varA = VldDBRecord.varA;
        double varB = VldDBRecord.varB;
        double pValueNormal = VldDBRecord.testStat.pValNormal;
        double botCInormal = VldDBRecord.testStat.ciBotNormal;
        double topCInormal = VldDBRecord.testStat.ciTopNormal;
        double rejectNormal = VldDBRecord.testStat.rejectNormal;
        double dfBDG = VldDBRecord.testStat.DF_BDG;
        double pValueBDG = VldDBRecord.testStat.pValBDG;
        double botCIBDG = VldDBRecord.testStat.ciBotBDG;
        double topCIBDG = VldDBRecord.testStat.ciTopBDG;
        double rejectBDG = VldDBRecord.testStat.rejectBDG;
        double dfHillis = VldDBRecord.testStat.DF_Hillis;
        double pValueHillis = VldDBRecord.testStat.pValHillis;
        double botCIHillis = VldDBRecord.testStat.ciBotHillis;
        double topCIHillis = VldDBRecord.testStat.ciTopHillis;
        double rejectHillis = VldDBRecord.testStat.rejectHillis;
        str = String.valueOf(str) + "MCmean" + SEPA + fourDecE.format(AUC_A) + SEPA + fourDecE.format(AUC_B) + SEPA + fourDecE.format(AUC_AminusAUC_B) + SEPA + fourDecE.format(varA) + SEPA + fourDecE.format(varB) + SEPA + fourDecE.format(totalVar) + SEPA;
        str = String.valueOf(str) + fourDecE.format(pValueNormal) + SEPA + fourDecE.format(botCInormal) + SEPA + fourDecE.format(topCInormal) + SEPA + fourDecE.format(rejectNormal) + SEPA;
        str = String.valueOf(str) + fourDecE.format(dfBDG) + SEPA + fourDecE.format(pValueBDG) + SEPA + fourDecE.format(botCIBDG) + SEPA + fourDecE.format(topCIBDG) + SEPA + fourDecE.format(rejectBDG) + SEPA;
        str = Double.isNaN(rejectHillis) ? String.valueOf(str) + "NaN,NaN,NaN,NaN,NaN" + "\r\n" : String.valueOf(str) + fourDecE.format(dfHillis) + SEPA + fourDecE.format(pValueHillis) + SEPA + fourDecE.format(botCIHillis) + SEPA + fourDecE.format(topCIHillis) + SEPA + fourDecE.format(rejectHillis) + "\r\n";
        return str;
    }

    public static String exportNumValidation(String oldReport, DBRecord VldDBRecord) {
        String str = oldReport;
        double AUC_A = VldDBRecord.AUCsReaderAvg[0];
        double AUC_B = VldDBRecord.AUCsReaderAvg[1];
        double AUC_AminusAUC_B = AUC_A - AUC_B;
        double totalVar = VldDBRecord.totalVar;
        double varA = VldDBRecord.varA;
        double varB = VldDBRecord.varB;
        double pValueNormal = VldDBRecord.testStat.pValNormal;
        double botCInormal = VldDBRecord.testStat.ciBotNormal;
        double topCInormal = VldDBRecord.testStat.ciTopNormal;
        double rejectNormal = VldDBRecord.testStat.rejectNormal;
        double dfBDG = VldDBRecord.testStat.DF_BDG;
        double pValueBDG = VldDBRecord.testStat.pValBDG;
        double botCIBDG = VldDBRecord.testStat.ciBotBDG;
        double topCIBDG = VldDBRecord.testStat.ciTopBDG;
        double rejectBDG = VldDBRecord.testStat.rejectBDG;
        double dfHillis = VldDBRecord.testStat.DF_Hillis;
        double pValueHillis = VldDBRecord.testStat.pValHillis;
        double botCIHillis = VldDBRecord.testStat.ciBotHillis;
        double topCIHillis = VldDBRecord.testStat.ciTopHillis;
        double rejectHillis = VldDBRecord.testStat.rejectHillis;
        str = String.valueOf(str) + "NumStat" + SEPA + fourDecE.format(AUC_A) + SEPA + fourDecE.format(AUC_B) + SEPA + fourDecE.format(AUC_AminusAUC_B) + SEPA + fourDecE.format(varA) + SEPA + fourDecE.format(varB) + SEPA + fourDecE.format(totalVar) + SEPA;
        str = String.valueOf(str) + fourDecE.format(pValueNormal) + SEPA + fourDecE.format(botCInormal) + SEPA + fourDecE.format(topCInormal) + SEPA + fourDecE.format(rejectNormal) + SEPA;
        str = String.valueOf(str) + fourDecE.format(dfBDG) + SEPA + fourDecE.format(pValueBDG) + SEPA + fourDecE.format(botCIBDG) + SEPA + fourDecE.format(topCIBDG) + SEPA + fourDecE.format(rejectBDG) + SEPA;
        str = Double.isNaN(rejectHillis) ? String.valueOf(str) + "NaN,NaN,NaN,NaN,NaN" + "\r\n" : String.valueOf(str) + fourDecE.format(dfHillis) + SEPA + fourDecE.format(pValueHillis) + SEPA + fourDecE.format(botCIHillis) + SEPA + fourDecE.format(topCIHillis) + SEPA + fourDecE.format(rejectHillis) + "\r\n";
        return str;
    }

    public static String exportMCvarianceValidation(String oldReport, DBRecord VarDBRecord) {
        String str = oldReport;
        double mcVarAUC_A = VarDBRecord.AUCsReaderAvg[0];
        double mcVarAUC_B = VarDBRecord.AUCsReaderAvg[1];
        double mcVarAUC_AminusB = VarDBRecord.AUCsReaderAvg[2];
        double mcVarvarA = VarDBRecord.varA;
        double mcVarvarB = VarDBRecord.varB;
        double mcVartotalVar = VarDBRecord.totalVar;
        double mcVarpValueNormal = VarDBRecord.testStat.pValNormal;
        double mcVarbotCInormal = VarDBRecord.testStat.ciBotNormal;
        double mcVartopCInormal = VarDBRecord.testStat.ciTopNormal;
        double mcVarrejectNormal = VarDBRecord.testStat.rejectNormal;
        double mcVardfBDG = VarDBRecord.testStat.DF_BDG;
        double mcVarpValueBDG = VarDBRecord.testStat.pValBDG;
        double mcVarbotCIBDG = VarDBRecord.testStat.ciBotBDG;
        double mcVartopCIBDG = VarDBRecord.testStat.ciTopBDG;
        double mcVarrejectBDG = VarDBRecord.testStat.rejectBDG;
        double mcVardfHillis = VarDBRecord.testStat.DF_Hillis;
        double mcVarpValueHillis = VarDBRecord.testStat.pValHillis;
        double mcVarbotCIHillis = VarDBRecord.testStat.ciBotHillis;
        double mcVartopCIHillis = VarDBRecord.testStat.ciTopHillis;
        double mcVarrejectHillis = VarDBRecord.testStat.rejectHillis;
        str = String.valueOf(str) + "MCvar" + SEPA + fourDecE.format(mcVarAUC_A) + SEPA + fourDecE.format(mcVarAUC_B) + SEPA + fourDecE.format(mcVarAUC_AminusB) + SEPA + fourDecE.format(mcVarvarA) + SEPA + fourDecE.format(mcVarvarB) + SEPA + fourDecE.format(mcVartotalVar) + SEPA;
        str = String.valueOf(str) + fourDecE.format(mcVarpValueNormal) + SEPA + fourDecE.format(mcVarbotCInormal) + SEPA + fourDecE.format(mcVartopCInormal) + SEPA + fourDecE.format(mcVarrejectNormal) + SEPA;
        str = String.valueOf(str) + fourDecE.format(mcVardfBDG) + SEPA + fourDecE.format(mcVarpValueBDG) + SEPA + fourDecE.format(mcVarbotCIBDG) + SEPA + fourDecE.format(mcVartopCIBDG) + SEPA + fourDecE.format(mcVarrejectBDG) + SEPA;
        str = Double.isNaN(mcVarrejectHillis) ? String.valueOf(str) + "NaN,NaN,NaN,NaN,NaN" + "\r\n" : String.valueOf(str) + fourDecE.format(mcVardfHillis) + SEPA + fourDecE.format(mcVarpValueHillis) + SEPA + fourDecE.format(mcVarbotCIHillis) + SEPA + fourDecE.format(mcVartopCIHillis) + SEPA + fourDecE.format(mcVarrejectHillis) + "\r\n";
        return str;
    }

    public static String exportStat(String report, DBRecord StatDBRecord, String timestring) {
        String str = report;
        String inputfilename = StatDBRecord.InputFile1.fileName;
        str = String.valueOf(str) + inputfilename + SEPA;
        str = String.valueOf(str) + timestring + SEPA;
        str = String.valueOf(str) + "iMRMC Version 4.0.3" + SEPA;
        str = String.valueOf(str) + StatDBRecord.NreaderDB + SEPA;
        str = String.valueOf(str) + StatDBRecord.NnormalDB + SEPA;
        str = String.valueOf(str) + StatDBRecord.NdiseaseDB + SEPA;
        str = String.valueOf(str) + StatDBRecord.modalityA + SEPA;
        str = String.valueOf(str) + StatDBRecord.modalityB + SEPA;
        str = StatDBRecord.flagMLE == 1 ? String.valueOf(str) + "MLE" + SEPA : String.valueOf(str) + "Ustat" + SEPA;
        if (StatDBRecord.selectedMod == 0) {
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCsReaderAvg[0]) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.varA) + SEPA;
            str = String.valueOf(str) + "NA,NA,NA,NA" + SEPA;
        } else if (StatDBRecord.selectedMod == 1) {
            str = String.valueOf(str) + "NA,NA" + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCsReaderAvg[1]) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.varB) + SEPA;
            str = String.valueOf(str) + "NA,NA" + SEPA;
        } else {
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCsReaderAvg[0]) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.varA) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCsReaderAvg[1]) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.varB) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCsReaderAvg[0] - StatDBRecord.AUCsReaderAvg[1]) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.totalVar) + SEPA;
        }
        if (StatDBRecord.totalVar > 0.0) {
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.pValNormal) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciBotNormal) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciTopNormal) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.rejectNormal) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.DF_BDG) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.pValBDG) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciBotBDG) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciTopBDG) + SEPA;
            str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.rejectBDG) + SEPA;
            if (StatDBRecord.flagFullyCrossed) {
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.DF_Hillis) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.pValHillis) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciBotHillis) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.ciTopHillis) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.testStat.rejectHillis) + "\r\n";
            } else {
                str = String.valueOf(str) + "NA,NA,NA,NA,NA" + "\r\n";
            }
        } else {
            str = String.valueOf(str) + "NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA" + "\r\n";
        }
        return str;
    }

    public static String exportReaders(String report, DBRecord StatDBRecord, InputFile InputFile1, String timestring) {
        String str = report;
        String inputfilename = StatDBRecord.InputFile1.fileName;
        int i = 0;
        for (String desc_temp : InputFile1.readerIDs.keySet()) {
            str = String.valueOf(str) + inputfilename + SEPA;
            str = String.valueOf(str) + timestring + SEPA;
            str = String.valueOf(str) + "iMRMC Version 4.0.3" + SEPA;
            str = String.valueOf(str) + desc_temp + SEPA;
            if (StatDBRecord.selectedMod == 0) {
                str = String.valueOf(str) + StatDBRecord.N0perReader[i][0] + SEPA;
                str = String.valueOf(str) + StatDBRecord.N1perReader[i][0] + SEPA;
            } else if (StatDBRecord.selectedMod == 1) {
                str = String.valueOf(str) + StatDBRecord.N0perReader[i][1] + SEPA;
                str = String.valueOf(str) + StatDBRecord.N1perReader[i][1] + SEPA;
            } else {
                str = String.valueOf(str) + StatDBRecord.N0perReader[i][2] + SEPA;
                str = String.valueOf(str) + StatDBRecord.N1perReader[i][2] + SEPA;
            }
            str = String.valueOf(str) + StatDBRecord.modalityA + SEPA;
            str = String.valueOf(str) + StatDBRecord.modalityB + SEPA;
            if (StatDBRecord.selectedMod == 0) {
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCs[i][0]) + SEPA;
                str = String.valueOf(str) + (Double.isNaN(StatDBRecord.readerVarA[i]) ? "NA" : eightDecE.format(StatDBRecord.readerVarA[i])) + SEPA;
                str = String.valueOf(str) + "NA,NA,NA,NA" + SEPA;
            } else if (StatDBRecord.selectedMod == 1) {
                str = String.valueOf(str) + "NA,NA" + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCs[i][1]) + SEPA;
                str = String.valueOf(str) + (Double.isNaN(StatDBRecord.readerVarB[i]) ? "NA" : eightDecE.format(StatDBRecord.readerVarB[i])) + SEPA;
                str = String.valueOf(str) + "NA,NA" + SEPA;
            } else {
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCs[i][0]) + SEPA;
                str = String.valueOf(str) + (Double.isNaN(StatDBRecord.readerVarA[i]) ? "NA" : eightDecE.format(StatDBRecord.readerVarA[i])) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCs[i][1]) + SEPA;
                str = String.valueOf(str) + (Double.isNaN(StatDBRecord.readerVarB[i]) ? "NA" : eightDecE.format(StatDBRecord.readerVarB[i])) + SEPA;
                str = String.valueOf(str) + eightDecE.format(StatDBRecord.AUCs[i][0] - StatDBRecord.AUCs[i][1]) + SEPA;
                str = String.valueOf(str) + (Double.isNaN(StatDBRecord.readerTotalVar[i]) ? "NA" : eightDecE.format(StatDBRecord.readerTotalVar[i])) + SEPA;
            }
            ++i;
            str = String.valueOf(str) + "NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA,NA" + "\r\n";
        }
        return str;
    }

    public static String exportReadersCov(String readerCovReport, DBRecord StatDBRecord, InputFile InputFile1) {
        String str = readerCovReport;
        str = StatDBRecord.selectedMod == 0 ? String.valueOf(str) + StatDBRecord.modalityA + " VS " + StatDBRecord.modalityA + "\r\n" + "," : (StatDBRecord.selectedMod == 1 ? String.valueOf(str) + StatDBRecord.modalityB + " VS " + StatDBRecord.modalityB + "\r\n" + "," : String.valueOf(str) + StatDBRecord.modalityA + " VS " + StatDBRecord.modalityB + "\r\n" + ",");
        for (String desc_temp : InputFile1.readerIDs.keySet()) {
            str = String.valueOf(str) + desc_temp + SEPA;
        }
        str = String.valueOf(str) + "\r\n";
        int colReader = 0;
        for (String desc_temp : InputFile1.readerIDs.keySet()) {
            str = String.valueOf(str) + desc_temp + SEPA;
            int i = 0;
            while ((long)i < StatDBRecord.Nreader) {
                str = StatDBRecord.selectedMod == 0 ? String.valueOf(str) + (Double.isNaN(StatDBRecord.readerCovA[colReader][i]) ? "NA" : eightDecE.format(StatDBRecord.readerCovA[colReader][i])) + SEPA : (StatDBRecord.selectedMod == 1 ? String.valueOf(str) + (Double.isNaN(StatDBRecord.readerCovB[colReader][i]) ? "NA" : eightDecE.format(StatDBRecord.readerCovB[colReader][i])) + SEPA : String.valueOf(str) + (Double.isNaN(StatDBRecord.readerTotalCov[colReader][i]) ? "NA" : eightDecE.format(StatDBRecord.readerTotalCov[colReader][i])) + SEPA);
                ++i;
            }
            str = String.valueOf(str) + "\r\n";
            ++colReader;
        }
        return str;
    }

    public static String exportROC(XYSeriesCollection seriesCollection, String report) {
        XYSeries seriesget;
        String serisekey;
        String str = report;
        int maxColumn = 0;
        int j = 0;
        while (j < seriesCollection.getSeriesCount()) {
            serisekey = (String)((Object)seriesCollection.getSeriesKey(j));
            seriesget = seriesCollection.getSeries((Comparable)((Object)serisekey));
            maxColumn = Math.max(maxColumn, seriesget.getItemCount());
            ++j;
        }
        str = String.valueOf(str) + "ModalityID:ReaderID,Number of points,Axises";
        int i = 0;
        while (i < maxColumn) {
            str = String.valueOf(str) + SEPA;
            ++i;
        }
        str = String.valueOf(str) + "\r\n";
        j = 0;
        while (j < seriesCollection.getSeriesCount()) {
            serisekey = (String)((Object)seriesCollection.getSeriesKey(j));
            seriesget = seriesCollection.getSeries((Comparable)((Object)serisekey));
            str = String.valueOf(str) + serisekey + SEPA;
            str = String.valueOf(str) + Integer.toString(seriesget.getItemCount()) + SEPA;
            str = String.valueOf(str) + "FPF" + SEPA;
            int i2 = 0;
            while (i2 < seriesget.getItemCount()) {
                str = String.valueOf(str) + fourDec.format(seriesget.getX(i2)) + SEPA;
                ++i2;
            }
            i2 = seriesget.getItemCount();
            while (i2 < maxColumn) {
                str = String.valueOf(str) + SEPA;
                ++i2;
            }
            str = String.valueOf(str) + "\r\n" + serisekey + SEPA + Integer.toString(seriesget.getItemCount()) + SEPA + "TPF" + SEPA;
            i2 = 0;
            while (i2 < seriesget.getItemCount()) {
                str = String.valueOf(str) + fourDec.format(seriesget.getY(i2)) + SEPA;
                ++i2;
            }
            i2 = seriesget.getItemCount();
            while (i2 < maxColumn) {
                str = String.valueOf(str) + SEPA;
                ++i2;
            }
            str = String.valueOf(str) + "\r\n";
            ++j;
        }
        return str;
    }
}

