/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Ensembles.SPIDER;

import java.util.StringTokenizer;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.KNN;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.Metodo;
import keel.Algorithms.ImbalancedClassification.Ensembles.Basic.OutputIS;
import keel.Algorithms.ImbalancedClassification.Ensembles.multi_C45;
import keel.Dataset.Attributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class SPIDER
extends Metodo {
    private int k;
    private String type;

    public SPIDER(String ficheroScript) {
        super(ficheroScript);
    }

    public SPIDER(InstanceSet IS, int k, String spiderType, String distance) {
        this.type = spiderType;
        this.k = k;
        this.training = IS;
        this.test = IS;
        this.distanceEu = distance.equalsIgnoreCase("Euclidean");
        this.ficheroSalida = new String[2];
        this.ficheroSalida[0] = multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tra";
        this.ficheroSalida[1] = multi_C45.outputTr.substring(0, multi_C45.outputTr.length() - 4) + "train.tst";
        try {
            this.normalizar();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (!this.distanceEu) {
            stdDev = new double[Attributes.getInputNumAttributes()];
            nominalDistance = new double[Attributes.getInputNumAttributes()][][];
            int nClases = Attributes.getOutputAttribute(0).getNumNominalValues();
            for (int i = 0; i < nominalDistance.length; ++i) {
                int j;
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    SPIDER.nominalDistance[i] = new double[Attributes.getInputAttribute(i).getNumNominalValues()][Attributes.getInputAttribute(i).getNumNominalValues()];
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        SPIDER.nominalDistance[i][j][j] = 0.0;
                    }
                    for (j = 0; j < Attributes.getInputAttribute(i).getNumNominalValues(); ++j) {
                        for (int l = j + 1; l < Attributes.getInputAttribute(i).getNumNominalValues(); ++l) {
                            int m;
                            double VDM = 0.0;
                            int Nay = 0;
                            int Nax = 0;
                            for (m = 0; m < this.training.getNumInstances(); ++m) {
                                if (this.nominalTrain[m][i] == j) {
                                    ++Nax;
                                }
                                if (this.nominalTrain[m][i] != l) continue;
                                ++Nay;
                            }
                            for (m = 0; m < nClases; ++m) {
                                int Nayc = 0;
                                int Naxc = 0;
                                for (int n = 0; n < this.training.getNumInstances(); ++n) {
                                    if (this.nominalTrain[n][i] == j && this.clasesTrain[n] == m) {
                                        ++Naxc;
                                    }
                                    if (this.nominalTrain[n][i] != l || this.clasesTrain[n] != m) continue;
                                    ++Nayc;
                                }
                                VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                            }
                            SPIDER.nominalDistance[i][j][l] = Math.sqrt(VDM);
                            SPIDER.nominalDistance[i][l][j] = Math.sqrt(VDM);
                        }
                    }
                    continue;
                }
                double media = 0.0;
                double SD = 0.0;
                for (j = 0; j < this.training.getNumInstances(); ++j) {
                    media += this.realTrain[j][i];
                    SD += this.realTrain[j][i] * this.realTrain[j][i];
                }
                SPIDER.stdDev[i] = Math.sqrt(Math.abs(SD / (double)this.realTrain.length - (media /= (double)this.realTrain.length) * media));
            }
        }
    }

    public void ejecutar() {
        int j;
        int claseObt;
        int negID;
        int posID;
        int i;
        int nSel = 0;
        int nPos = 0;
        int nNeg = 0;
        int[] neighbours = null;
        long tiempo = System.currentTimeMillis();
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] == 0) {
                ++nPos;
                continue;
            }
            ++nNeg;
        }
        if (nPos > nNeg) {
            int tmp = nPos;
            nPos = nNeg;
            nNeg = tmp;
            posID = 1;
            negID = 0;
        } else {
            posID = 0;
            negID = 1;
        }
        boolean[] safe = new boolean[this.datosTrain.length];
        int[] amplify = new int[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            safe[i] = false;
            amplify[i] = 1;
        }
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        for (i = 0; i < this.datosTrain.length; ++i) {
            claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu);
            if (claseObt != this.clasesTrain[i]) continue;
            safe[i] = true;
        }
        if (this.type.equalsIgnoreCase("weak") || this.type.equalsIgnoreCase("relabel")) {
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (this.clasesTrain[i] != posID || safe[i]) continue;
                neighbours = new int[this.k];
                claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu, neighbours);
                for (j = 0; j < this.k; ++j) {
                    if (this.clasesTrain[neighbours[j]] == posID || !safe[neighbours[j]]) continue;
                    int n = i;
                    amplify[n] = amplify[n] + 1;
                }
            }
            if (this.type.equalsIgnoreCase("relabel")) {
                for (i = 0; i < this.datosTrain.length; ++i) {
                    if (this.clasesTrain[i] != posID || safe[i]) continue;
                    neighbours = new int[this.k];
                    claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu, neighbours);
                    for (j = 0; j < this.k; ++j) {
                        if (this.clasesTrain[neighbours[j]] == posID || safe[neighbours[j]]) continue;
                        this.clasesTrain[neighbours[j]] = posID;
                        safe[neighbours[j]] = true;
                    }
                }
            }
        } else {
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (this.clasesTrain[i] != posID || !safe[i]) continue;
                neighbours = new int[this.k];
                claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu, neighbours);
                for (j = 0; j < this.k; ++j) {
                    if (this.clasesTrain[neighbours[j]] == posID || !safe[neighbours[j]]) continue;
                    int n = i;
                    amplify[n] = amplify[n] + 1;
                }
            }
            for (i = 0; i < this.datosTrain.length; ++i) {
                if (this.clasesTrain[i] != posID || safe[i]) continue;
                claseObt = KNN.evaluacionKNN2(this.k + 2, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu);
                if (claseObt == this.clasesTrain[i]) {
                    neighbours = new int[this.k];
                    claseObt = KNN.evaluacionKNN2(this.k, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu, neighbours);
                    for (j = 0; j < this.k; ++j) {
                        if (this.clasesTrain[neighbours[j]] == posID || !safe[neighbours[j]]) continue;
                        int n = i;
                        amplify[n] = amplify[n] + 1;
                    }
                    continue;
                }
                neighbours = new int[this.k + 2];
                claseObt = KNN.evaluacionKNN2(this.k + 2, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu, neighbours);
                for (j = 0; j < this.k + 2; ++j) {
                    if (this.clasesTrain[neighbours[j]] == posID || !safe[neighbours[j]]) continue;
                    int n = i;
                    amplify[n] = amplify[n] + 1;
                }
            }
        }
        nSel = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (this.clasesTrain[i] != posID && (this.clasesTrain[i] != negID || !safe[i])) continue;
            nSel += amplify[i];
        }
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (this.clasesTrain[i] != posID && (this.clasesTrain[i] != negID || !safe[i])) continue;
            for (int t = 0; t < amplify[i]; ++t) {
                for (j = 0; j < this.datosTrain[0].length; ++j) {
                    conjS[l][j] = this.datosTrain[i][j];
                    conjR[l][j] = this.realTrain[i][j];
                    conjN[l][j] = this.nominalTrain[i][j];
                    conjM[l][j] = this.nulosTrain[i][j];
                }
                clasesS[l] = this.clasesTrain[i];
                ++l;
            }
        }
        System.out.println("SPIDER " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.type = tokens.nextToken().substring(1);
    }
}

