/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.C45Rules;

import keel.Algorithms.Rule_Learning.C45Rules.IncrementalMask;
import org.core.Randomize;

public class Mask {
    private boolean[] mask;
    private int nactivos;
    private int index;

    public Mask() {
    }

    public Mask(int size) {
        this.mask = new boolean[size];
        this.nactivos = size;
        for (int i = 0; i < size; ++i) {
            this.mask[i] = true;
        }
        this.index = -1;
    }

    public Mask(int size, boolean initial) {
        this.mask = new boolean[size];
        this.nactivos = size;
        for (int i = 0; i < size; ++i) {
            this.mask[i] = initial;
        }
        this.index = -1;
    }

    private Mask(boolean[] mask, int nactivos) {
        this.mask = mask;
        this.nactivos = nactivos;
        this.index = -1;
    }

    public Mask copy() {
        boolean[] replicate = new boolean[this.mask.length];
        for (int i = 0; i < this.mask.length; ++i) {
            replicate[i] = this.mask[i];
        }
        return new Mask(replicate, this.nactivos);
    }

    public void copyTo(Mask replicate) {
        for (int i = 0; i < this.mask.length; ++i) {
            replicate.mask[i] = this.mask[i];
        }
        replicate.nactivos = this.nactivos;
        replicate.index = -1;
    }

    public void reset() {
        if (this.mask[this.index]) {
            --this.nactivos;
        }
        this.mask[this.index] = false;
    }

    public void change(int i) {
        boolean bl = this.mask[i] = !this.mask[i];
        this.nactivos = this.mask[i] ? ++this.nactivos : --this.nactivos;
    }

    public void set(int i) {
        if (!this.mask[i]) {
            ++this.nactivos;
        }
        this.mask[i] = true;
    }

    public boolean isActive(int i) {
        return this.mask[i];
    }

    public void reset(int i) {
        if (this.mask[i]) {
            --this.nactivos;
        }
        this.mask[i] = false;
    }

    public void set(int i, boolean value) {
        if (this.mask[i]) {
            --this.nactivos;
        }
        this.mask[i] = value;
        if (this.mask[i]) {
            ++this.nactivos;
        }
    }

    public Mask complement() {
        Mask comp = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            comp.mask[i] = !this.mask[i];
        }
        comp.nactivos = this.mask.length - this.nactivos;
        return comp;
    }

    public Mask and(Mask m) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            boolean bl = output.mask[i] = this.mask[i] && m.mask[i];
            if (output.mask[i]) continue;
            --output.nactivos;
        }
        return output;
    }

    public Mask and(IncrementalMask im) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            boolean bl = output.mask[i] = this.mask[i] && im.get(i) != 0;
            if (output.mask[i]) continue;
            --output.nactivos;
        }
        return output;
    }

    public Mask or(Mask m) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            boolean bl = output.mask[i] = this.mask[i] || m.mask[i];
            if (output.mask[i]) continue;
            --output.nactivos;
        }
        return output;
    }

    public Mask or(Mask[] m) {
        Mask output = new Mask(this.mask.length, false);
        output = output.or(this);
        for (int i = 0; i < m.length; ++i) {
            output = output.or(m[i]);
        }
        return output;
    }

    public Mask or(IncrementalMask im) {
        Mask output = new Mask(this.mask.length);
        for (int i = 0; i < this.mask.length; ++i) {
            boolean bl = output.mask[i] = this.mask[i] || im.get(i) != 0;
            if (output.mask[i]) continue;
            --output.nactivos;
        }
        return output;
    }

    public int getnActive() {
        return this.nactivos;
    }

    public boolean next() {
        do {
            ++this.index;
        } while (this.index < this.mask.length && !this.mask[this.index]);
        return this.index < this.mask.length;
    }

    public int getIndex() {
        return this.index;
    }

    public void resetIndex() {
        this.index = -1;
    }

    public Mask[] split(double pct, Randomize rand) {
        boolean[] half1 = new boolean[this.mask.length];
        boolean[] half2 = new boolean[this.mask.length];
        int[] availables = new int[this.mask.length];
        for (int j = 0; j < this.mask.length; ++j) {
            half1[j] = false;
            half2[j] = false;
        }
        int i = 0;
        this.resetIndex();
        while (this.next()) {
            availables[i] = this.getIndex();
            ++i;
            half2[this.getIndex()] = true;
        }
        int j = 0;
        while ((double)j < Math.floor(pct * (double)this.nactivos)) {
            int num = Randomize.Randint(0, i - j);
            half1[availables[num]] = true;
            half2[availables[num]] = false;
            availables[num] = availables[i - j - 1];
            ++j;
        }
        Mask output1 = new Mask(half1, (int)Math.floor(pct * (double)this.nactivos));
        Mask output2 = new Mask(half2, this.nactivos - output1.getnActive());
        Mask[] outputv = new Mask[]{output1, output2};
        return outputv;
    }
}

