/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.experiment.CSVResultListener;
import weka.experiment.ClassifierSplitEvaluator;
import weka.experiment.OutputZipper;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;
import weka.experiment.SplitEvaluator;

public class RandomSplitResultProducer
implements ResultProducer,
OptionHandler,
AdditionalMeasureProducer {
    static final long serialVersionUID = 1403798165056795073L;
    protected Instances m_Instances;
    protected ResultListener m_ResultListener = new CSVResultListener();
    protected double m_TrainPercent = 66.0;
    protected boolean m_randomize = true;
    protected SplitEvaluator m_SplitEvaluator = new ClassifierSplitEvaluator();
    protected String[] m_AdditionalMeasures = null;
    protected boolean m_debugOutput = false;
    protected OutputZipper m_ZipDest = null;
    protected File m_OutputFile = new File(new File(System.getProperty("user.dir")), "splitEvalutorOut.zip");
    public static String DATASET_FIELD_NAME = "Dataset";
    public static String RUN_FIELD_NAME = "Run";
    public static String TIMESTAMP_FIELD_NAME = "Date_time";

    public String globalInfo() {
        return "Generates a single train/test split and calls the appropriate SplitEvaluator to generate some results.";
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_SplitEvaluator != null) {
            System.err.println("RandomSplitResultProducer: setting additional measures for split evaluator");
            this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_SplitEvaluator instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_SplitEvaluator)).getMeasure(string);
        }
        throw new IllegalArgumentException("RandomSplitResultProducer: Can't return value for : " + string + ". " + this.m_SplitEvaluator.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public void setResultListener(ResultListener resultListener) {
        this.m_ResultListener = resultListener;
    }

    public static Double getTimestamp() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        double d = (double)(calendar.get(1) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5)) + (double)calendar.get(11) / 100.0 + (double)calendar.get(12) / 10000.0;
        return new Double(d);
    }

    public void preProcess() throws Exception {
        if (this.m_SplitEvaluator == null) {
            throw new Exception("No SplitEvalutor set");
        }
        if (this.m_ResultListener == null) {
            throw new Exception("No ResultListener set");
        }
        this.m_ResultListener.preProcess(this);
    }

    public void postProcess() throws Exception {
        this.m_ResultListener.postProcess(this);
        if (this.m_debugOutput && this.m_ZipDest != null) {
            this.m_ZipDest.finished();
            this.m_ZipDest = null;
        }
    }

    public void doRunKeys(int n) throws Exception {
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] objectArray = this.m_SplitEvaluator.getKey();
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        objectArray2[1] = "" + n;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        if (this.m_ResultListener.isResultRequired(this, objectArray2)) {
            this.m_ResultListener.acceptResult(this, objectArray2, null);
        }
    }

    public void doRun(int n) throws Exception {
        if (this.getRawOutput() && this.m_ZipDest == null) {
            this.m_ZipDest = new OutputZipper(this.m_OutputFile);
        }
        if (this.m_Instances == null) {
            throw new Exception("No Instances set");
        }
        Object[] objectArray = this.m_SplitEvaluator.getKey();
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = Utils.backQuoteChars(this.m_Instances.relationName());
        objectArray2[1] = "" + n;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        if (this.m_ResultListener.isResultRequired(this, objectArray2)) {
            Object object;
            Instances instances;
            Instances instances2;
            int n2;
            Instances instances3 = new Instances(this.m_Instances);
            if (!this.m_randomize) {
                int n3 = Utils.round((double)instances3.numInstances() * this.m_TrainPercent / 100.0);
                n2 = instances3.numInstances() - n3;
                instances2 = new Instances(instances3, 0, n3);
                instances = new Instances(instances3, n3, n2);
            } else {
                Random random = new Random(n);
                instances3.randomize(random);
                if (instances3.classAttribute().isNominal()) {
                    int n4;
                    n2 = instances3.numClasses();
                    object = new Instances[n2 + 1];
                    for (int i = 0; i < n2 + 1; ++i) {
                        object[i] = new Instances(instances3, 10);
                    }
                    Enumeration enumeration = instances3.enumerateInstances();
                    while (enumeration.hasMoreElements()) {
                        Instance instance = (Instance)enumeration.nextElement();
                        if (instance.classIsMissing()) {
                            object[n2].add(instance);
                            continue;
                        }
                        object[(int)instance.classValue()].add(instance);
                    }
                    for (n4 = 0; n4 < n2 + 1; ++n4) {
                        object[n4].compactify();
                    }
                    instances2 = new Instances(instances3, instances3.numInstances());
                    instances = new Instances(instances3, instances3.numInstances());
                    for (n4 = 0; n4 < n2 + 1; ++n4) {
                        int n5;
                        int n6 = Utils.probRound((double)object[n4].numInstances() * this.m_TrainPercent / 100.0, random);
                        for (n5 = 0; n5 < n6; ++n5) {
                            instances2.add(object[n4].instance(n5));
                        }
                        for (n5 = n6; n5 < object[n4].numInstances(); ++n5) {
                            instances.add(object[n4].instance(n5));
                        }
                        object[n4] = null;
                    }
                    instances2.compactify();
                    instances.compactify();
                    instances2.randomize(random);
                    instances.randomize(random);
                } else {
                    n2 = Utils.probRound((double)instances3.numInstances() * this.m_TrainPercent / 100.0, random);
                    int n7 = instances3.numInstances() - n2;
                    instances2 = new Instances(instances3, 0, n2);
                    instances = new Instances(instances3, n2, n7);
                }
            }
            Object[] objectArray3 = this.m_SplitEvaluator.getResult(instances2, instances);
            Object[] objectArray4 = new Object[objectArray3.length + 1];
            objectArray4[0] = RandomSplitResultProducer.getTimestamp();
            System.arraycopy(objectArray3, 0, objectArray4, 1, objectArray3.length);
            if (this.m_debugOutput) {
                object = ("" + n + "." + Utils.backQuoteChars(instances3.relationName()) + "." + this.m_SplitEvaluator.toString()).replace(' ', '_');
                object = Utils.removeSubstring((String)object, "weka.classifiers.");
                object = Utils.removeSubstring((String)object, "weka.filters.");
                object = Utils.removeSubstring((String)object, "weka.attributeSelection.");
                this.m_ZipDest.zipit(this.m_SplitEvaluator.getRawResultOutput(), (String)object);
            }
            this.m_ResultListener.acceptResult(this, objectArray2, objectArray4);
        }
    }

    public String[] getKeyNames() {
        String[] stringArray = this.m_SplitEvaluator.getKeyNames();
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = DATASET_FIELD_NAME;
        stringArray2[1] = RUN_FIELD_NAME;
        System.arraycopy(stringArray, 0, stringArray2, 2, stringArray.length);
        return stringArray2;
    }

    public Object[] getKeyTypes() {
        Object[] objectArray = this.m_SplitEvaluator.getKeyTypes();
        Object[] objectArray2 = new String[objectArray.length + 2];
        objectArray2[0] = new String();
        objectArray2[1] = new String();
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        return objectArray2;
    }

    public String[] getResultNames() {
        String[] stringArray = this.m_SplitEvaluator.getResultNames();
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = TIMESTAMP_FIELD_NAME;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }

    public Object[] getResultTypes() {
        Object[] objectArray = this.m_SplitEvaluator.getResultTypes();
        Object[] objectArray2 = new Object[objectArray.length + 1];
        objectArray2[0] = new Double(0.0);
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        return objectArray2;
    }

    public String getCompatibilityState() {
        String string = "-P " + this.m_TrainPercent;
        if (!this.getRandomizeData()) {
            string = string + " -R";
        }
        string = this.m_SplitEvaluator == null ? string + " <null SplitEvaluator>" : string + " -W " + this.m_SplitEvaluator.getClass().getName();
        return string + " --";
    }

    public String outputFileTipText() {
        return "Set the destination for saving raw output. If the rawOutput option is selected, then output from the splitEvaluator for individual train-test splits is saved. If the destination is a directory, then each output is saved to an individual gzip file; if the destination is a file, then each output is saved as an entry in a zip file.";
    }

    public File getOutputFile() {
        return this.m_OutputFile;
    }

    public void setOutputFile(File file) {
        this.m_OutputFile = file;
    }

    public String randomizeDataTipText() {
        return "Do not randomize dataset and do not perform probabilistic rounding if true";
    }

    public boolean getRandomizeData() {
        return this.m_randomize;
    }

    public void setRandomizeData(boolean bl) {
        this.m_randomize = bl;
    }

    public String rawOutputTipText() {
        return "Save raw output (useful for debugging). If set, then output is sent to the destination specified by outputFile";
    }

    public boolean getRawOutput() {
        return this.m_debugOutput;
    }

    public void setRawOutput(boolean bl) {
        this.m_debugOutput = bl;
    }

    public String trainPercentTipText() {
        return "Set the percentage of data to use for training.";
    }

    public double getTrainPercent() {
        return this.m_TrainPercent;
    }

    public void setTrainPercent(double d) {
        this.m_TrainPercent = d;
    }

    public String splitEvaluatorTipText() {
        return "The evaluator to apply to the test data. This may be a classifier, regression scheme etc.";
    }

    public SplitEvaluator getSplitEvaluator() {
        return this.m_SplitEvaluator;
    }

    public void setSplitEvaluator(SplitEvaluator splitEvaluator) {
        this.m_SplitEvaluator = splitEvaluator;
        this.m_SplitEvaluator.setAdditionalMeasures(this.m_AdditionalMeasures);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(5);
        vector.addElement(new Option("\tThe percentage of instances to use for training.\n\t(default 66)", "P", 1, "-P <percent>"));
        vector.addElement(new Option("Save raw split evaluator output.", "D", 0, "-D"));
        vector.addElement(new Option("\tThe filename where raw output will be stored.\n\tIf a directory name is specified then then individual\n\toutputs will be gzipped, otherwise all output will be\n\tzipped to the named file. Use in conjuction with -D.\t(default splitEvalutorOut.zip)", "O", 1, "-O <file/directory name/path>"));
        vector.addElement(new Option("\tThe full class name of a SplitEvaluator.\n\teg: weka.experiment.ClassifierSplitEvaluator", "W", 1, "-W <class name>"));
        vector.addElement(new Option("\tSet when data is not to be randomized and the data sets' size.\n\tIs not to be determined via probabilistic rounding.", "R", 0, "-R"));
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to split evaluator " + this.m_SplitEvaluator.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_SplitEvaluator)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string;
        this.setRawOutput(Utils.getFlag('D', stringArray));
        this.setRandomizeData(!Utils.getFlag('R', stringArray));
        String string2 = Utils.getOption('O', stringArray);
        if (string2.length() != 0) {
            this.setOutputFile(new File(string2));
        }
        if ((string = Utils.getOption('P', stringArray)).length() != 0) {
            this.setTrainPercent(new Double(string));
        } else {
            this.setTrainPercent(66.0);
        }
        String string3 = Utils.getOption('W', stringArray);
        if (string3.length() == 0) {
            throw new Exception("A SplitEvaluator must be specified with the -W option.");
        }
        this.setSplitEvaluator((SplitEvaluator)Utils.forName(SplitEvaluator.class, string3, null));
        if (this.getSplitEvaluator() instanceof OptionHandler) {
            ((OptionHandler)((Object)this.getSplitEvaluator())).setOptions(Utils.partitionOptions(stringArray));
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_SplitEvaluator != null && this.m_SplitEvaluator instanceof OptionHandler) {
            stringArray = ((OptionHandler)((Object)this.m_SplitEvaluator)).getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 9];
        int n = 0;
        stringArray2[n++] = "-P";
        stringArray2[n++] = "" + this.getTrainPercent();
        if (this.getRawOutput()) {
            stringArray2[n++] = "-D";
        }
        if (!this.getRandomizeData()) {
            stringArray2[n++] = "-R";
        }
        stringArray2[n++] = "-O";
        stringArray2[n++] = this.getOutputFile().getName();
        if (this.getSplitEvaluator() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getSplitEvaluator().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public String toString() {
        String string = "RandomSplitResultProducer: ";
        string = string + this.getCompatibilityState();
        string = this.m_Instances == null ? string + ": <null Instances>" : string + ": " + Utils.backQuoteChars(this.m_Instances.relationName());
        return string;
    }
}

