/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Utils;
import weka.core.matrix.CholeskyDecomposition;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.LUDecomposition;
import weka.core.matrix.LinearRegression;
import weka.core.matrix.Maths;
import weka.core.matrix.QRDecomposition;
import weka.core.matrix.SingularValueDecomposition;

public class Matrix
implements Cloneable,
Serializable {
    protected double[][] A;
    protected int m;
    protected int n;

    public Matrix(int n, int n2) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.m = n;
        this.n = n2;
        this.A = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.A[i][j] = d;
            }
        }
    }

    public Matrix(double[][] dArray) {
        this.m = dArray.length;
        this.n = dArray[0].length;
        for (int i = 0; i < this.m; ++i) {
            if (dArray[i].length == this.n) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.A = dArray;
    }

    public Matrix(double[][] dArray, int n, int n2) {
        this.A = dArray;
        this.m = n;
        this.n = n2;
    }

    public Matrix(double[] dArray, int n) {
        this.m = n;
        int n2 = this.n = n != 0 ? dArray.length / n : 0;
        if (n * this.n != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of m.");
        }
        this.A = new double[n][this.n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = dArray[i + j * n];
            }
        }
    }

    public Matrix(Reader reader) throws Exception {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            StringTokenizer stringTokenizer;
            if (string.startsWith("%") || !(stringTokenizer = new StringTokenizer(string)).hasMoreTokens()) continue;
            if (n < 0) {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of columns");
                }
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                this.A = new double[n2][n3];
                this.m = n2;
                this.n = n3;
                ++n;
                continue;
            }
            if (n == this.getRowDimension()) {
                throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too many rows provided");
            }
            for (n2 = 0; n2 < this.getColumnDimension(); ++n2) {
                if (!stringTokenizer.hasMoreTokens()) {
                    throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few matrix elements provided");
                }
                this.set(n, n2, Double.valueOf(stringTokenizer.nextToken()));
            }
            ++n;
        }
        if (n == -1) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": expected number of rows");
        }
        if (n != this.getRowDimension()) {
            throw new Exception("Line " + lineNumberReader.getLineNumber() + ": too few rows provided");
        }
    }

    public static Matrix constructWithCopy(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            if (dArray[i].length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j];
            }
        }
        return matrix;
    }

    public Matrix copy() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return matrix;
    }

    public Object clone() {
        return this.copy();
    }

    public double[][] getArray() {
        return this.A;
    }

    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m][this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i + j * this.m] = this.A[i][j];
            }
        }
        return dArray;
    }

    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m * this.n];
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i * this.n + j] = this.A[i][j];
            }
        }
        return dArray;
    }

    public int getRowDimension() {
        return this.m;
    }

    public int getColumnDimension() {
        return this.n;
    }

    public double get(int n, int n2) {
        return this.A[n][n2];
    }

    public Matrix getMatrix(int n, int n2, int n3, int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    dArray[i - n][j - n3] = this.A[i][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    dArray[i][j] = this.A[nArray[i]][nArray2[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int n, int n2, int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    dArray[i - n][j] = this.A[i][nArray[j]];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public Matrix getMatrix(int[] nArray, int n, int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.getArray();
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    dArray[i][j - n] = this.A[nArray[i]][j];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
        return matrix;
    }

    public void set(int n, int n2, double d) {
        this.A[n][n2] = d;
    }

    public void setMatrix(int n, int n2, int n3, int n4, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    this.A[i][j] = matrix.get(i - n, j - n3);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int[] nArray2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < nArray2.length; ++j) {
                    this.A[nArray[i]][nArray2[j]] = matrix.get(i, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int[] nArray, int n, int n2, Matrix matrix) {
        try {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = n; j <= n2; ++j) {
                    this.A[nArray[i]][j] = matrix.get(i, j - n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public void setMatrix(int n, int n2, int[] nArray, Matrix matrix) {
        try {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < nArray.length; ++j) {
                    this.A[i][nArray[j]] = matrix.get(i - n, j);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException("Submatrix indices");
        }
    }

    public boolean isSymmetric() {
        int n = this.A.length;
        int n2 = this.A[0].length;
        if (n != n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.A[i][j] == this.A[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare() {
        return this.getRowDimension() == this.getColumnDimension();
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.n, this.m);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[j][i] = this.A[i][j];
            }
        }
        return matrix;
    }

    public double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m; ++j) {
                d2 += Math.abs(this.A[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.n; ++j) {
                d2 += Math.abs(this.A[i][j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                d = Maths.hypot(d, this.A[i][j]);
            }
        }
        return d;
    }

    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = -this.A[i][j];
            }
        }
        return matrix;
    }

    public Matrix plus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] + matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix plusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] + matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix minus(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] - matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix minusEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] - matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayTimes(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] * matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayTimesEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] * matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayRightDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = this.A[i][j] / matrix.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayRightDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = this.A[i][j] / matrix.A[i][j];
            }
        }
        return this;
    }

    public Matrix arrayLeftDivide(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m, this.n);
        double[][] dArray = matrix2.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = matrix.A[i][j] / this.A[i][j];
            }
        }
        return matrix2;
    }

    public Matrix arrayLeftDivideEquals(Matrix matrix) {
        this.checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = matrix.A[i][j] / this.A[i][j];
            }
        }
        return this;
    }

    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.m, this.n);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                dArray[i][j] = d * this.A[i][j];
            }
        }
        return matrix;
    }

    public Matrix timesEquals(double d) {
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.A[i][j] = d * this.A[i][j];
            }
        }
        return this;
    }

    public Matrix times(Matrix matrix) {
        if (matrix.m != this.n) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m, matrix.n);
        double[][] dArray = matrix2.getArray();
        double[] dArray2 = new double[this.n];
        for (int i = 0; i < matrix.n; ++i) {
            int n;
            for (n = 0; n < this.n; ++n) {
                dArray2[n] = matrix.A[n][i];
            }
            for (n = 0; n < this.m; ++n) {
                double[] dArray3 = this.A[n];
                double d = 0.0;
                for (int j = 0; j < this.n; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                dArray[n][i] = d;
            }
        }
        return matrix2;
    }

    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    public Matrix solve(Matrix matrix) {
        return this.m == this.n ? new LUDecomposition(this).solve(matrix) : new QRDecomposition(this).solve(matrix);
    }

    public Matrix solveTranspose(Matrix matrix) {
        return this.transpose().solve(matrix.transpose());
    }

    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m, this.m));
    }

    public Matrix sqrt() {
        Matrix matrix = null;
        EigenvalueDecomposition eigenvalueDecomposition = this.eig();
        Matrix matrix2 = eigenvalueDecomposition.getV();
        Matrix matrix3 = eigenvalueDecomposition.getD();
        Matrix matrix4 = new Matrix(matrix3.getRowDimension(), matrix3.getColumnDimension());
        for (int i = 0; i < matrix4.getRowDimension(); ++i) {
            for (int j = 0; j < matrix4.getColumnDimension(); ++j) {
                matrix4.set(i, j, StrictMath.sqrt(matrix3.get(i, j)));
            }
        }
        Matrix matrix5 = matrix2.inverse();
        Matrix matrix6 = matrix2.times(matrix4).inverse();
        matrix2 = null;
        matrix3 = null;
        eigenvalueDecomposition = null;
        matrix4 = null;
        matrix = matrix5.solve(matrix6).inverse();
        return matrix;
    }

    public LinearRegression regression(Matrix matrix, double d) {
        return new LinearRegression(this, matrix, d);
    }

    public final LinearRegression regression(Matrix matrix, double[] dArray, double d) {
        return new LinearRegression(this, matrix, dArray, d);
    }

    public double det() {
        return new LUDecomposition(this).det();
    }

    public int rank() {
        return new SingularValueDecomposition(this).rank();
    }

    public double cond() {
        return new SingularValueDecomposition(this).cond();
    }

    public double trace() {
        double d = 0.0;
        for (int i = 0; i < Math.min(this.m, this.n); ++i) {
            d += this.A[i][i];
        }
        return d;
    }

    public static Matrix random(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = Math.random();
            }
        }
        return matrix;
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public void print(int n, int n2) {
        this.print(new PrintWriter(System.out, true), n, n2);
    }

    public void print(PrintWriter printWriter, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
        decimalFormat.setMinimumIntegerDigits(1);
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        this.print(printWriter, decimalFormat, n + 2);
    }

    public void print(NumberFormat numberFormat, int n) {
        this.print(new PrintWriter(System.out, true), numberFormat, n);
    }

    public void print(PrintWriter printWriter, NumberFormat numberFormat, int n) {
        printWriter.println();
        for (int i = 0; i < this.m; ++i) {
            for (int j = 0; j < this.n; ++j) {
                String string = numberFormat.format(this.A[i][j]);
                int n2 = Math.max(1, n - string.length());
                for (int k = 0; k < n2; ++k) {
                    printWriter.print(' ');
                }
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public static Matrix read(BufferedReader bufferedReader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        Vector<Object> vector = new Vector<Object>();
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        do {
            vector.addElement(Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = vector.size();
        double[] dArray = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray[n] = (Double)vector.elementAt(n);
        }
        vector.removeAllElements();
        vector.addElement(dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            vector.addElement(dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + vector.size() + " is too long.");
                }
                dArray[n++] = Double.valueOf(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + vector.size() + " is too short.");
        }
        n = vector.size();
        double[][] dArrayArray = new double[n][];
        vector.copyInto((Object[])dArrayArray);
        return new Matrix(dArrayArray);
    }

    private void checkMatrixDimensions(Matrix matrix) {
        if (matrix.m != this.m || matrix.n != this.n) {
            throw new IllegalArgumentException("Matrix dimensions must agree.");
        }
    }

    public void write(Writer writer) throws Exception {
        writer.write("% Rows\tColumns\n");
        writer.write("" + this.getRowDimension() + "\t" + this.getColumnDimension() + "\n");
        writer.write("% Matrix elements\n");
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                writer.write("" + this.get(i, j) + "\t");
            }
            writer.write("\n");
        }
        writer.flush();
    }

    public String toString() {
        int n;
        double d = 0.0;
        boolean bl = false;
        for (n = 0; n < this.getRowDimension(); ++n) {
            for (int i = 0; i < this.getColumnDimension(); ++i) {
                double d2 = this.get(n, i);
                if (d2 < 0.0) {
                    d2 *= -11.0;
                }
                if (d2 > d) {
                    d = d2;
                }
                double d3 = Math.abs(d2 - Math.rint(d2));
                if (bl || !(Math.log(d3) / Math.log(10.0) >= -2.0)) continue;
                bl = true;
            }
        }
        n = (int)(Math.log(d) / Math.log(10.0) + (double)(bl ? 4 : 1));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getRowDimension(); ++i) {
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                stringBuffer.append(" ").append(Utils.doubleToString(this.get(i, j), n, bl ? 2 : 0));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toMatlab() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < this.getRowDimension(); ++i) {
            if (i > 0) {
                stringBuffer.append("; ");
            }
            for (int j = 0; j < this.getColumnDimension(); ++j) {
                if (j > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(Double.toString(this.get(i, j)));
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static Matrix parseMatlab(String string) throws Exception {
        String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]")).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        int n = stringTokenizer.countTokens();
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ");
        int n2 = stringTokenizer2.countTokens();
        Matrix matrix = new Matrix(n, n2);
        stringTokenizer = new StringTokenizer(string2, ";");
        n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), " ");
            n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                matrix.set(n, n2, Double.parseDouble(stringTokenizer2.nextToken()));
                ++n2;
            }
            ++n;
        }
        return matrix;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("\nIdentity\n");
            Matrix matrix = Matrix.identity(3, 5);
            System.out.println("I(3,5)\n" + matrix);
            System.out.println("\nbasic operations - square\n");
            Matrix matrix2 = Matrix.random(3, 3);
            Matrix matrix3 = Matrix.random(3, 3);
            System.out.println("A\n" + matrix2);
            System.out.println("B\n" + matrix3);
            System.out.println("A'\n" + matrix2.inverse());
            System.out.println("A^T\n" + matrix2.transpose());
            System.out.println("A+B\n" + matrix2.plus(matrix3));
            System.out.println("A*B\n" + matrix2.times(matrix3));
            System.out.println("X from A*X=B\n" + matrix2.solve(matrix3));
            System.out.println("\nbasic operations - non square\n");
            matrix2 = Matrix.random(2, 3);
            matrix3 = Matrix.random(3, 4);
            System.out.println("A\n" + matrix2);
            System.out.println("B\n" + matrix3);
            System.out.println("A*B\n" + matrix2.times(matrix3));
            System.out.println("\nsqrt (1)\n");
            matrix2 = new Matrix(new double[][]{{5.0, -4.0, 1.0, 0.0, 0.0}, {-4.0, 6.0, -4.0, 1.0, 0.0}, {1.0, -4.0, 6.0, -4.0, 1.0}, {0.0, 1.0, -4.0, 6.0, -4.0}, {0.0, 0.0, 1.0, -4.0, 5.0}});
            System.out.println("A\n" + matrix2);
            System.out.println("sqrt(A)\n" + matrix2.sqrt());
            System.out.println("\nsqrt (2)\n");
            matrix2 = new Matrix(new double[][]{{7.0, 10.0}, {15.0, 22.0}});
            System.out.println("A\n" + matrix2);
            System.out.println("sqrt(A)\n" + matrix2.sqrt());
            System.out.println("det(A)\n" + matrix2.det() + "\n");
            System.out.println("\nEigenvalue Decomposition\n");
            EigenvalueDecomposition eigenvalueDecomposition = matrix2.eig();
            System.out.println("[V,D] = eig(A)");
            System.out.println("- V\n" + eigenvalueDecomposition.getV());
            System.out.println("- D\n" + eigenvalueDecomposition.getD());
            System.out.println("\nLU Decomposition\n");
            LUDecomposition lUDecomposition = matrix2.lu();
            System.out.println("[L,U,P] = lu(A)");
            System.out.println("- L\n" + lUDecomposition.getL());
            System.out.println("- U\n" + lUDecomposition.getU());
            System.out.println("- P\n" + Utils.arrayToString(lUDecomposition.getPivot()) + "\n");
            System.out.println("\nRegression\n");
            matrix3 = new Matrix(new double[][]{{3.0}, {2.0}});
            double d = 0.5;
            double[] dArray = new double[]{0.3, 0.7};
            LinearRegression linearRegression = matrix2.regression(matrix3, d);
            System.out.println("A\n" + matrix2);
            System.out.println("B\n" + matrix3);
            System.out.println("ridge = " + d + "\n");
            System.out.println("weights = " + Utils.arrayToString(dArray) + "\n");
            System.out.println("A.regression(B, ridge)\n" + matrix2.regression(matrix3, d) + "\n");
            System.out.println("A.regression(B, weights, ridge)\n" + matrix2.regression(matrix3, dArray, d) + "\n");
            System.out.println("\nWriter/Reader\n");
            StringWriter stringWriter = new StringWriter();
            matrix2.write(stringWriter);
            System.out.println("A.write(Writer)\n" + stringWriter);
            matrix2 = new Matrix(new StringReader(stringWriter.toString()));
            System.out.println("A = new Matrix.read(Reader)\n" + matrix2);
            System.out.println("\nMatlab-Format\n");
            String string = "[ 1   2;3 4 ]";
            System.out.println("Matlab: " + string);
            System.out.println("from Matlab:\n" + Matrix.parseMatlab(string));
            System.out.println("to Matlab:\n" + Matrix.parseMatlab(string).toMatlab());
            string = "[1 2 3 4;3 4 5 6;7 8 9 10]";
            System.out.println("Matlab: " + string);
            System.out.println("from Matlab:\n" + Matrix.parseMatlab(string));
            System.out.println("to Matlab:\n" + Matrix.parseMatlab(string).toMatlab() + "\n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

