/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.BackwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.Generator;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPAgendaEntry;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreter;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPInterpreterContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPRuleStore;
import com.hp.hpl.jena.reasoner.rulesys.impl.LPTopGoalIterator;
import com.hp.hpl.jena.reasoner.rulesys.impl.RuleClauseCode;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LPBRuleEngine {
    protected LPRuleStore ruleStore;
    protected BackwardRuleInfGraphI infGraph;
    protected boolean traceOn = false;
    protected boolean recordDerivations;
    protected List activeInterpreters = new ArrayList();
    protected HashMap tabledGoals = new HashMap();
    protected LinkedList agenda = new LinkedList();
    protected HashMap profile;
    public static final int CYCLES_BETWEEN_COMPLETION_CHECK = 3;
    static Log logger = LogFactory.getLog((Class)LPBRuleEngine.class);

    public LPBRuleEngine(BackwardRuleInfGraphI infGraph, LPRuleStore rules) {
        this.infGraph = infGraph;
        this.ruleStore = rules;
    }

    public LPBRuleEngine(BackwardRuleInfGraphI infGraph) {
        this.infGraph = infGraph;
        this.ruleStore = new LPRuleStore();
    }

    public synchronized ExtendedIterator find(TriplePattern goal) {
        LPInterpreter interpreter = new LPInterpreter(this, goal);
        this.activeInterpreters.add(interpreter);
        return WrappedIterator.create(new LPTopGoalIterator(interpreter));
    }

    public synchronized void reset() {
        this.checkSafeToUpdate();
        this.tabledGoals = new HashMap();
        this.agenda.clear();
    }

    public synchronized void addRule(Rule rule) {
        this.checkSafeToUpdate();
        if (rule.headLength() > 1) {
            throw new ReasonerException("Backward rules only allowed one head clause");
        }
        this.ruleStore.addRule(rule);
    }

    public synchronized void deleteRule(Rule rule) {
        this.checkSafeToUpdate();
        this.ruleStore.deleteRule(rule);
    }

    public synchronized List getAllRules() {
        this.checkSafeToUpdate();
        return this.ruleStore.getAllRules();
    }

    public synchronized void deleteAllRules() {
        this.checkSafeToUpdate();
        this.ruleStore.deleteAllRules();
    }

    public synchronized void halt() {
        ArrayList copy = new ArrayList(this.activeInterpreters);
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ((LPInterpreter)i.next()).close();
        }
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
    }

    public boolean getDerivationLogging() {
        return this.recordDerivations;
    }

    public LPRuleStore getRuleStore() {
        return this.ruleStore;
    }

    public BackwardRuleInfGraphI getInfGraph() {
        return this.infGraph;
    }

    public synchronized void detach(LPInterpreter engine) {
        this.activeInterpreters.remove(engine);
    }

    public void checkSafeToUpdate() {
        if (!this.activeInterpreters.isEmpty()) {
            ArrayList<LPInterpreterContext> toClose = new ArrayList<LPInterpreterContext>();
            Iterator i = this.activeInterpreters.iterator();
            while (i.hasNext()) {
                LPInterpreter interpreter = (LPInterpreter)i.next();
                if (!(interpreter.getContext() instanceof LPTopGoalIterator)) continue;
                toClose.add(interpreter.getContext());
            }
            i = toClose.iterator();
            while (i.hasNext()) {
                ((LPTopGoalIterator)i.next()).close();
            }
        }
    }

    public synchronized void tablePredicate(Node predicate) {
        this.ruleStore.tablePredicate(predicate);
    }

    public synchronized Generator generatorFor(TriplePattern goal, List clauses) {
        Generator generator = (Generator)this.tabledGoals.get(goal);
        if (generator == null) {
            LPInterpreter interpreter = new LPInterpreter(this, goal, clauses, false);
            this.activeInterpreters.add(interpreter);
            generator = new Generator(interpreter, goal);
            this.schedule(generator);
            this.tabledGoals.put(goal, generator);
        }
        return generator;
    }

    public synchronized Generator generatorFor(TriplePattern goal) {
        Generator generator = (Generator)this.tabledGoals.get(goal);
        if (generator == null) {
            LPInterpreter interpreter = new LPInterpreter(this, goal, false);
            this.activeInterpreters.add(interpreter);
            generator = new Generator(interpreter, goal);
            this.schedule(generator);
            this.tabledGoals.put(goal, generator);
        }
        return generator;
    }

    public void schedule(LPAgendaEntry state) {
        this.agenda.add(state);
    }

    public synchronized void pump(LPInterpreterContext gen) {
        ArrayList<Generator> batch = null;
        batch = new ArrayList<Generator>(3);
        int count = 0;
        while (!gen.isReady()) {
            if (this.agenda.isEmpty()) {
                return;
            }
            int chosen = this.agenda.size() - 1;
            LPAgendaEntry next = (LPAgendaEntry)this.agenda.get(chosen);
            this.agenda.remove(chosen);
            next.pump();
            batch.add(next.getGenerator());
            if (++count % 3 != 0) continue;
            Generator.checkForCompletions(batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            Generator.checkForCompletions(batch);
        }
    }

    public void checkForCompletions() {
        ArrayList<LPInterpreterContext> contexts = new ArrayList<LPInterpreterContext>(this.activeInterpreters.size());
        Iterator i = this.activeInterpreters.iterator();
        while (i.hasNext()) {
            LPInterpreter interpreter = (LPInterpreter)i.next();
            if (!(interpreter.getContext() instanceof Generator)) continue;
            contexts.add(interpreter.getContext());
        }
        Generator.checkForCompletions(contexts);
    }

    public void incrementProfile(RuleClauseCode clause) {
        if (this.profile != null) {
            String index = clause.toString();
            Count count = (Count)this.profile.get(index);
            if (count == null) {
                this.profile.put(index, new Count(clause).inc());
            } else {
                count.inc();
            }
        }
    }

    public void resetProfile(boolean enable) {
        this.profile = enable ? new HashMap() : null;
    }

    public void printProfile() {
        if (this.profile == null) {
            System.out.println("No profile collected");
        } else {
            ArrayList counts = new ArrayList();
            counts.addAll(this.profile.values());
            Collections.sort(counts);
            System.out.println("LP engine rule profile");
            Iterator i = counts.iterator();
            while (i.hasNext()) {
                System.out.println(i.next());
            }
        }
    }

    static class Count
    implements Comparable {
        protected int count = 0;
        protected RuleClauseCode clause;

        public Count(RuleClauseCode clause) {
            this.clause = clause;
        }

        public int getCount() {
            return this.count;
        }

        public Count inc() {
            ++this.count;
            return this;
        }

        public int compareTo(Object other) {
            Count otherCount = (Count)other;
            return this.count < otherCount.count ? -1 : (this.count == otherCount.count ? 0 : 1);
        }

        public String toString() {
            return " " + this.count + "\t - " + this.clause;
        }
    }
}

