/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphMaker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class ModelMakerImpl
implements ModelMaker {
    protected GraphMaker maker;
    protected Model description;

    public ModelMakerImpl(GraphMaker maker) {
        this.maker = maker;
    }

    public GraphMaker getGraphMaker() {
        return this.maker;
    }

    public void close() {
        this.maker.close();
    }

    public Model openModel() {
        return new ModelCom(this.maker.openGraph());
    }

    protected Model makeModel(Graph g) {
        return new ModelCom(g);
    }

    public Model openModelIfPresent(String name) {
        return this.maker.hasGraph(name) ? this.openModel(name) : null;
    }

    public Model openModel(String name, boolean strict) {
        return this.makeModel(this.maker.openGraph(name, strict));
    }

    public Model openModel(String name) {
        return this.openModel(name, false);
    }

    public Model createModel(String name, boolean strict) {
        return this.makeModel(this.maker.createGraph(name, strict));
    }

    public Model createModel(String name) {
        return this.createModel(name, false);
    }

    public Model createModelOver(String name) {
        return this.createModel(name);
    }

    public Model createFreshModel() {
        return this.makeModel(this.maker.createGraph());
    }

    public Model createDefaultModel() {
        return this.makeModel(this.maker.getGraph());
    }

    public Model getDescription() {
        if (this.description == null) {
            this.description = this.makeModel(this.maker.getDescription());
        }
        return this.description;
    }

    public Model getDescription(Resource root) {
        return this.makeModel(this.maker.getDescription(root.asNode()));
    }

    public Model addDescription(Model m, Resource self) {
        return this.makeModel(this.maker.addDescription(m.getGraph(), self.asNode()));
    }

    public void removeModel(String name) {
        this.maker.removeGraph(name);
    }

    public boolean hasModel(String name) {
        return this.maker.hasGraph(name);
    }

    public ExtendedIterator listModels() {
        return this.maker.listGraphs();
    }

    public Model getModel() {
        return this.createDefaultModel();
    }

    public Model createModel() {
        return this.createFreshModel();
    }

    public Model getModel(String URL2) {
        return this.hasModel(URL2) ? this.openModel(URL2) : null;
    }

    public Model getModel(String URL2, ModelReader loadIfAbsent) {
        Model already = this.getModel(URL2);
        return already == null ? loadIfAbsent.readModel(this.createModel(URL2), URL2) : already;
    }
}

