/*
 * Decompiled with CFR 0.152.
 */
package jd2.xml.sa;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.StringFormatter;
import javax.xml.bind.annotation.XmlAttribute;
import jd2.xml.sa.XmlAoDefinition;
import jd2.xml.sa.XmlLsDefinition;
import jd2.xml.sa.XmlSoDefinition;
import jd2.xml.sa.XmlTcDefinition;

public abstract class AbstractXmlOutlierDefinition {
    @XmlAttribute
    public String period;
    @XmlAttribute
    public Boolean prespecified;

    public boolean isPrespecifiedOutlier() {
        return this.prespecified == null ? true : this.prespecified;
    }

    public void setPrespecifiedOutlier(boolean p) {
        this.prespecified = p ? null : Boolean.valueOf(p);
    }

    protected abstract OutlierType getType();

    public OutlierDefinition getDefinition() {
        Day p = StringFormatter.convertDay((String)this.period);
        if (p != null) {
            return new OutlierDefinition(p, this.getType());
        }
        TsPeriod pos = StringFormatter.readPeriod((String)this.period);
        if (pos != null) {
            return new OutlierDefinition(pos, this.getType());
        }
        return null;
    }

    public static AbstractXmlOutlierDefinition create(OutlierDefinition def) {
        AbstractXmlOutlierDefinition x = null;
        if (def.getType() == OutlierType.AO) {
            x = new XmlAoDefinition();
        } else if (def.getType() == OutlierType.LS) {
            x = new XmlLsDefinition();
        } else if (def.getType() == OutlierType.TC) {
            x = new XmlTcDefinition();
        } else if (def.getType() == OutlierType.SO) {
            x = new XmlSoDefinition();
        }
        if (x != null) {
            x.period = StringFormatter.convert((Day)def.getPosition());
        }
        return x;
    }
}

