/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries;

import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.IDomain;
import ec.tstoolkit.timeseries.IPeriod;
import ec.tstoolkit.timeseries.Week;

public class Weeks
implements IDomain {
    private final int m_start;
    private final int m_n;

    public Weeks() {
        this.m_start = 0;
        this.m_n = 0;
    }

    public Weeks(Day start, int nweeks) {
        this.m_start = start.getId();
        this.m_n = nweeks;
    }

    public Weeks(Week week, int nweeks) {
        this.m_start = week.getId();
        this.m_n = nweeks;
    }

    public Weeks(Weeks weeks) {
        this.m_start = weeks.m_start;
        this.m_n = weeks.m_n;
    }

    @Override
    public IPeriod get(int idx) {
        return new Week(this.m_start + 7 * idx);
    }

    @Override
    public int getLength() {
        return this.m_n;
    }

    @Override
    public int search(Day day) {
        int id = day.getId() - this.m_start;
        if (id < 0) {
            return -1;
        }
        int idx = id / 7;
        if (idx >= this.m_n) {
            return -1;
        }
        return idx;
    }
}

