/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.ssf.BaseOrdinaryState;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.SsfException;
import ec.tstoolkit.ssf.State;

public class FastState
extends BaseOrdinaryState {
    public DataBlock L;

    public FastState(FastState state) {
        super(state);
        this.L = state.L.deepClone();
    }

    public FastState(int n, boolean hasdata) {
        super(n, hasdata);
        this.L = new DataBlock(n);
    }

    public FastState(ISsf ssf, State state, int pos) {
        super(ssf.getStateDim(), true);
        int dim = ssf.getStateDim();
        this.L = new DataBlock(dim);
        this.A.copy(state.A);
        this.f = ssf.ZVZ(pos, state.P.subMatrix());
        ssf.ZM(pos, state.P.subMatrix(), this.C);
        ssf.TX(pos, this.C);
        Matrix P = state.P;
        Matrix TVT = P.clone();
        ssf.TVT(pos, TVT.subMatrix());
        Matrix Q = new Matrix(dim, dim);
        ssf.fullQ(pos, Q.subMatrix());
        TVT.add(Q);
        TVT.sub(P);
        for (int i = 0; i < dim; ++i) {
            double kv = -this.C.get(i) / this.f;
            if (kv == 0.0) continue;
            TVT.add(i, i, kv * this.C.get(i));
            for (int j = 0; j < i; ++j) {
                TVT.add(i, j, kv * this.C.get(j));
                TVT.add(j, i, kv * this.C.get(j));
            }
        }
        TVT.mul(-this.f);
        int imax = 0;
        double lmax = TVT.get(0, 0);
        for (int i = 1; i < dim; ++i) {
            double lcur = TVT.get(i, i);
            if (!(lcur > lmax)) continue;
            imax = i;
            lmax = lcur;
        }
        if (lmax > 0.0) {
            this.L.copy(TVT.column(imax));
            this.L.mul(Math.sqrt(1.0 / lmax));
        } else {
            if (!TVT.isZero(1.0E-6)) {
                throw new SsfException("Invalid fast filter");
            }
            this.L.set(0.0);
        }
    }

    public void copy(FastState state) {
        super.copy(state);
        this.L = state.L.deepClone();
    }
}

