/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.codon;

import dr.evolution.datatype.Codons;
import dr.evomodel.substmodel.DefaultEigenSystem;
import dr.evomodel.substmodel.DifferentiableSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.evomodel.substmodel.DifferentialMassProvider;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.ParameterReplaceableSubstitutionModel;
import dr.evomodel.substmodel.codon.AbstractCodonModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class GY94CodonModel
extends AbstractCodonModel
implements Citable,
ParameterReplaceableSubstitutionModel,
DifferentiableSubstitutionModel {
    protected Parameter kappaParameter;
    protected Parameter omegaParameter;
    public static Citation CITATION = new Citation(new Author[]{new Author("N", "Goldman"), new Author("Z", "Yang")}, "A codon-based model of nucleotide substitution for protein-coding DNA sequences", 1994, "Mol Biol Evol", 11, 725, 736);

    public GY94CodonModel(Codons codons, Parameter parameter, Parameter parameter2, FrequencyModel frequencyModel) {
        this(codons, parameter, parameter2, frequencyModel, new DefaultEigenSystem(codons.getStateCount()));
    }

    public GY94CodonModel(Codons codons, Parameter parameter, Parameter parameter2, FrequencyModel frequencyModel, EigenSystem eigenSystem) {
        super("GY94", codons, frequencyModel, eigenSystem);
        this.omegaParameter = parameter;
        int n = parameter.getDimension();
        double d = parameter.getParameterValue(n - 1);
        if (d < 0.0) {
            throw new RuntimeException("Negative Omega parameter value " + d);
        }
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.kappaParameter = parameter2;
        n = parameter2.getDimension();
        d = parameter2.getParameterValue(n - 1);
        if (d < 0.0) {
            throw new RuntimeException("Negative kappa parameter value value " + d);
        }
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter2.getDimension()));
        Statistic.Abstract abstract_ = new Statistic.Abstract(){

            @Override
            public String getStatisticName() {
                return "synonymousRate";
            }

            @Override
            public int getDimension() {
                return 1;
            }

            @Override
            public double getStatisticValue(int n) {
                return GY94CodonModel.this.getSynonymousRate();
            }
        };
        this.addStatistic(abstract_);
    }

    public void setKappa(double d) {
        this.kappaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public double getKappa() {
        return this.kappaParameter.getParameterValue(0);
    }

    public void setOmega(double d) {
        this.omegaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public double getOmega() {
        return this.omegaParameter.getParameterValue(0);
    }

    private double getSynonymousRate() {
        double d = this.getKappa();
        double d2 = this.getOmega();
        return (31.0 * d + 36.0) / (31.0 * d + 36.0 + 138.0 * d2 + 58.0 * d2 * d);
    }

    @Override
    protected void setupRelativeRates(double[] dArray) {
        double d = this.getKappa();
        double d2 = this.getOmega();
        block7: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 0: {
                    dArray[i] = 0.0;
                    continue block7;
                }
                case 1: {
                    dArray[i] = d;
                    continue block7;
                }
                case 2: {
                    dArray[i] = 1.0;
                    continue block7;
                }
                case 3: {
                    dArray[i] = d * d2;
                    continue block7;
                }
                case 4: {
                    dArray[i] = d2;
                }
            }
        }
    }

    public String toXHTML() {
        return "<em>Goldman Yang 94 Codon Model</em> kappa = " + this.getKappa() + ", omega = " + this.getOmega();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Goldman-Yang codon substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }

    @Override
    public ParameterReplaceableSubstitutionModel factory(List<Parameter> list, List<Parameter> list2) {
        Parameter parameter = this.omegaParameter;
        Parameter parameter2 = this.kappaParameter;
        FrequencyModel frequencyModel = this.freqModel;
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter3 = list.get(i);
            Parameter parameter4 = list2.get(i);
            if (parameter3 != this.omegaParameter) {
                throw new RuntimeException("Parameter not found in GY94Codon SubstitutionModel.");
            }
            parameter = parameter4;
        }
        return new GY94CodonModel(this.codonDataType, parameter, parameter2, frequencyModel);
    }

    @Override
    public void setupDifferentialRates(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[] dArray, double d) {
        for (int i = 0; i < this.rateCount; ++i) {
            dArray[i] = wrtParameter.getRate(this.rateMap[i]) / d;
        }
    }

    @Override
    public double getWeightedNormalizationGradient(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter, double[][] dArray, double[] dArray2) {
        return this.getNormalizationValue(dArray, dArray2);
    }

    @Override
    public WrappedMatrix getInfinitesimalDifferentialMatrix(DifferentialMassProvider.DifferentialWrapper.WrtParameter wrtParameter) {
        return DifferentiableSubstitutionModelUtil.getInfinitesimalDifferentialMatrix(wrtParameter, this);
    }

    @Override
    public DifferentialMassProvider.DifferentialWrapper.WrtParameter factory(Parameter parameter) {
        if (parameter != this.omegaParameter) {
            throw new RuntimeException("Not yet implemented!");
        }
        Omega omega = new Omega();
        return omega;
    }

    class Omega
    implements DifferentialMassProvider.DifferentialWrapper.WrtParameter {
        Omega() {
        }

        @Override
        public double getRate(int n) {
            double d = GY94CodonModel.this.getKappa();
            switch (n) {
                case 0: {
                    return 0.0;
                }
                case 1: {
                    return 0.0;
                }
                case 2: {
                    return 0.0;
                }
                case 3: {
                    return d;
                }
                case 4: {
                    return 1.0;
                }
            }
            throw new IllegalArgumentException("Invalid switch case");
        }

        @Override
        public double getNormalizationDifferential() {
            return 1.0;
        }
    }
}

