/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.periodpriors;

import dr.evomodel.epidemiology.casetocase.periodpriors.AbstractPeriodPriorDistribution;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class OneOverStDevPeriodPriorDistribution
extends AbstractPeriodPriorDistribution {
    public static final String ONE_OVER_STDEV = "oneOverStDevPeriodPriorDistribution";
    public static final String LOG = "log";
    public static final String ID = "id";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("log", true), AttributeRule.newStringRule("id", false)};

        @Override
        public String getParserName() {
            return OneOverStDevPeriodPriorDistribution.ONE_OVER_STDEV;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = (String)xMLObject.getAttribute(OneOverStDevPeriodPriorDistribution.ID);
            boolean bl = xMLObject.hasAttribute(OneOverStDevPeriodPriorDistribution.LOG) ? xMLObject.getBooleanAttribute(OneOverStDevPeriodPriorDistribution.LOG) : false;
            return new OneOverStDevPeriodPriorDistribution(string, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the probability of observing a list of doubles with probability proportional to1 over their standard deviation (the Jeffreys prior for normally distributed data)";
        }

        @Override
        public Class getReturnType() {
            return OneOverStDevPeriodPriorDistribution.class;
        }
    };

    public OneOverStDevPeriodPriorDistribution(String string, boolean bl) {
        super(string, bl);
    }

    @Override
    public void reset() {
    }

    @Override
    public double calculateLogPosteriorProbability(double d, double d2) {
        return 0.0;
    }

    @Override
    public double calculateLogPosteriorCDF(double d, boolean bl) {
        return 0.0;
    }

    @Override
    public double calculateLogLikelihood(double[] dArray) {
        DescriptiveStatistics descriptiveStatistics = new DescriptiveStatistics(dArray);
        this.logL = -Math.log(descriptiveStatistics.getStandardDeviation());
        return this.logL;
    }
}

